/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.base.ParquetTimeUtils;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.LongBuffer;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

final class LocalDateTimeArrayTransfer
extends PrimitiveArrayAndVectorTransfer<LocalDateTime[], LocalDateTime[], LongBuffer> {
    LocalDateTimeArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, LongBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    int getSize(LocalDateTime @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = LongBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<LocalDateTime[]> data) {
        for (LocalDateTime t : (LocalDateTime[])data.encodedValues) {
            ((LongBuffer)this.buffer).put(ParquetTimeUtils.epochNanosUTC((LocalDateTime)t));
        }
    }
}

