/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.base.ParquetTimeUtils;
import io.deephaven.parquet.table.transfer.GettingPrimitiveTransfer;
import java.nio.LongBuffer;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

final class LocalDateTimeTransfer
extends GettingPrimitiveTransfer<ObjectChunk<LocalDateTime, Values>, LongBuffer> {
    LocalDateTimeTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, LongBuffer.allocate(Math.toIntExact(Math.min(tableRowSet.size(), (long)(targetPageSizeInBytes / 8)))), Math.toIntExact(Math.min(tableRowSet.size(), (long)(targetPageSizeInBytes / 8))));
    }

    @Override
    void copyAllFromChunkToBuffer() {
        int chunkSize = ((ObjectChunk)this.chunk).size();
        for (int chunkIdx = 0; chunkIdx < chunkSize; ++chunkIdx) {
            ((LongBuffer)this.buffer).put(ParquetTimeUtils.epochNanosUTC((LocalDateTime)((LocalDateTime)((ObjectChunk)this.chunk).get(chunkIdx))));
        }
    }
}

