/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.LongBuffer;
import org.jetbrains.annotations.NotNull;

final class LongArrayTransfer
extends PrimitiveArrayAndVectorTransfer<long[], long[], LongBuffer> {
    LongArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, LongBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    int getSize(long @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = LongBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<long[]> data) {
        ((LongBuffer)this.buffer).put((long[])data.encodedValues);
    }
}

