/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.FillingPrimitiveTransfer;
import java.nio.LongBuffer;
import org.jetbrains.annotations.NotNull;

final class LongTransfer
extends FillingPrimitiveTransfer<WritableLongChunk<Values>, LongBuffer> {
    static LongTransfer create(@NotNull ColumnSource<?> columnSource, @NotNull RowSet tableRowSet, int targetPageSizeInBytes) {
        int targetElementsPerPage = Math.toIntExact(Math.min(tableRowSet.size(), (long)(targetPageSizeInBytes / 8)));
        long[] backingArray = new long[targetElementsPerPage];
        return new LongTransfer(columnSource, (RowSequence)tableRowSet, (WritableLongChunk<Values>)WritableLongChunk.writableChunkWrap((long[])backingArray), LongBuffer.wrap(backingArray), targetElementsPerPage);
    }

    private LongTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, @NotNull WritableLongChunk<Values> chunk, @NotNull LongBuffer buffer, int targetElementsPerPage) {
        super(columnSource, tableRowSet, chunk, buffer, targetElementsPerPage);
    }
}

