/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.vector.LongVector;
import java.nio.LongBuffer;
import org.jetbrains.annotations.NotNull;

final class LongVectorTransfer
extends PrimitiveVectorTransfer<LongVector, LongBuffer> {
    LongVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, LongBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = LongBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<LongVector> data) {
        try (CloseablePrimitiveIteratorOfLong dataIterator = ((LongVector)data.encodedValues).iterator();){
            dataIterator.forEachRemaining(value -> ((LongBuffer)this.buffer).put(value));
        }
    }
}

