/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.ArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.parquet.io.api.Binary;
import org.jetbrains.annotations.NotNull;

abstract class ObjectArrayAndVectorTransfer<COLUMN_TYPE, VALUE_TYPE>
extends ArrayAndVectorTransfer<COLUMN_TYPE, Binary[], Binary[]> {
    private int bufferedDataCount = 0;
    private int numBytesBuffered = 0;
    private Binary[] encodedDataBuf;
    private int encodedDataBufLen;

    ObjectArrayAndVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSize) {
        super(columnSource, tableRowSet, targetPageSize, targetPageSize, new Binary[targetPageSize]);
        this.encodedDataBuf = new Binary[targetPageSize];
        this.encodedDataBufLen = 0;
    }

    @Override
    public final int transferOnePageToBuffer() {
        if (this.bufferedDataCount != 0) {
            Arrays.fill((Object[])this.buffer, 0, this.bufferedDataCount, null);
            this.bufferedDataCount = 0;
            this.numBytesBuffered = 0;
            this.repeatCounts.clear();
        }
        this.transferOnePageToBufferHelper();
        this.repeatCounts.flip();
        return this.bufferedDataCount;
    }

    @Override
    final int getNumBytesBuffered() {
        return this.numBytesBuffered;
    }

    final void encodeDataForBufferingHelper(@NotNull Supplier<VALUE_TYPE> objectSupplier, int numObjects, @NotNull VariableWidthTransfer.EncodedData<Binary[]> encodedData) {
        if (numObjects > this.encodedDataBuf.length) {
            this.encodedDataBuf = new Binary[numObjects];
        } else {
            Arrays.fill(this.encodedDataBuf, 0, this.encodedDataBufLen, null);
            this.encodedDataBufLen = 0;
        }
        int numBytesEncoded = 0;
        for (int i = 0; i < numObjects; ++i) {
            VALUE_TYPE value = objectSupplier.get();
            if (value == null) {
                this.encodedDataBuf[i] = null;
                continue;
            }
            this.encodedDataBuf[i] = this.encodeToBinary(value);
            numBytesEncoded += this.encodedDataBuf[i].length();
        }
        this.encodedDataBufLen = numObjects;
        encodedData.fillRepeated(this.encodedDataBuf, numBytesEncoded, numObjects);
    }

    abstract Binary encodeToBinary(VALUE_TYPE var1);

    @Override
    final boolean addEncodedDataToBuffer(@NotNull VariableWidthTransfer.EncodedData<Binary[]> data, boolean force) {
        if (force && (this.repeatCounts.position() != 0 || this.bufferedDataCount != 0)) {
            Assert.statementNeverExecuted();
            return false;
        }
        if (!this.repeatCounts.hasRemaining()) {
            return false;
        }
        int numEncodedValues = data.numValues;
        if (this.bufferedDataCount + numEncodedValues > this.targetElementsPerPage) {
            if (force) {
                if (((Binary[])this.buffer).length < numEncodedValues) {
                    this.buffer = new Binary[numEncodedValues];
                }
            } else {
                return false;
            }
        }
        for (int i = 0; i < numEncodedValues; ++i) {
            ((Binary[])this.buffer)[this.bufferedDataCount++] = ((Binary[])data.encodedValues)[i];
        }
        this.numBytesBuffered += data.numBytes;
        this.repeatCounts.put(numEncodedValues);
        return true;
    }
}

