/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.util.Arrays;
import org.apache.parquet.io.api.Binary;
import org.jetbrains.annotations.NotNull;

abstract class ObjectTransfer<COLUMN_TYPE>
extends VariableWidthTransfer<COLUMN_TYPE, Binary, Binary[]> {
    private int bufferedDataCount = 0;
    private int numBytesBuffered = 0;

    ObjectTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes, targetPageSizeInBytes, new Binary[targetPageSizeInBytes]);
    }

    @Override
    public final int transferOnePageToBuffer() {
        if (this.bufferedDataCount != 0) {
            Arrays.fill((Object[])this.buffer, 0, this.bufferedDataCount, null);
            this.bufferedDataCount = 0;
            this.numBytesBuffered = 0;
        }
        this.transferOnePageToBufferHelper();
        return this.bufferedDataCount;
    }

    @Override
    final int getNumBytesBuffered() {
        return this.numBytesBuffered;
    }

    @Override
    final boolean isBufferEmpty() {
        return this.bufferedDataCount == 0;
    }

    @Override
    final boolean addNullToBuffer() {
        if (this.bufferedDataCount == this.targetElementsPerPage) {
            return false;
        }
        ((Binary[])this.buffer)[this.bufferedDataCount++] = null;
        return true;
    }

    @Override
    final boolean addEncodedDataToBuffer(@NotNull VariableWidthTransfer.EncodedData<Binary> data, boolean force) {
        if (force && this.bufferedDataCount != 0) {
            Assert.statementNeverExecuted();
            return false;
        }
        if (this.bufferedDataCount == this.targetElementsPerPage) {
            return false;
        }
        ((Binary[])this.buffer)[this.bufferedDataCount++] = (Binary)data.encodedValues;
        this.numBytesBuffered += data.numBytes;
        return true;
    }
}

