/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.ObjectArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.vector.ObjectVector;
import java.util.function.Supplier;
import org.apache.parquet.io.api.Binary;
import org.jetbrains.annotations.NotNull;

abstract class ObjectVectorTransfer<VALUE_TYPE>
extends ObjectArrayAndVectorTransfer<ObjectVector<VALUE_TYPE>, VALUE_TYPE> {
    ObjectVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes);
    }

    @Override
    final void encodeDataForBuffering(@NotNull ObjectVector<VALUE_TYPE> data, @NotNull VariableWidthTransfer.EncodedData<Binary[]> encodedData) {
        try (CloseableIterator iter = data.iterator();){
            Supplier<Object> supplier = () -> iter.next();
            this.encodeDataForBufferingHelper(supplier, data.intSize(), encodedData);
        }
    }
}

