/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.ArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.Buffer;
import org.jetbrains.annotations.NotNull;

abstract class PrimitiveArrayAndVectorTransfer<COLUMN_TYPE, ENCODED_COLUMN_TYPE, BUFFER_TYPE extends Buffer>
extends ArrayAndVectorTransfer<COLUMN_TYPE, ENCODED_COLUMN_TYPE, BUFFER_TYPE> {
    private final int numBytesPerValue;

    PrimitiveArrayAndVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetElementsPerPage, int targetPageSizeInBytes, @NotNull BUFFER_TYPE buffer, int numBytesPerValue) {
        super(columnSource, tableRowSet, targetElementsPerPage, targetPageSizeInBytes, buffer);
        this.numBytesPerValue = numBytesPerValue;
    }

    @Override
    public int transferOnePageToBuffer() {
        ((Buffer)this.buffer).clear();
        this.repeatCounts.clear();
        this.transferOnePageToBufferHelper();
        ((Buffer)this.buffer).flip();
        this.repeatCounts.flip();
        return ((Buffer)this.buffer).limit();
    }

    @Override
    void encodeDataForBuffering(@NotNull COLUMN_TYPE data, @NotNull VariableWidthTransfer.EncodedData<ENCODED_COLUMN_TYPE> encodedData) {
        int numValues = this.getSize(data);
        encodedData.fillRepeated(data, numValues * this.numBytesPerValue, numValues);
    }

    int getSize(@NotNull COLUMN_TYPE data) {
        throw new UnsupportedOperationException("getSize() not implemented for " + this.getClass().getSimpleName());
    }

    @Override
    final int getNumBytesBuffered() {
        return ((Buffer)this.buffer).position() * this.numBytesPerValue;
    }

    @Override
    final boolean addEncodedDataToBuffer(@NotNull VariableWidthTransfer.EncodedData<ENCODED_COLUMN_TYPE> data, boolean force) {
        if (force && (this.repeatCounts.position() != 0 || ((Buffer)this.buffer).position() != 0)) {
            Assert.statementNeverExecuted();
            return false;
        }
        if (!this.repeatCounts.hasRemaining()) {
            return false;
        }
        if (((Buffer)this.buffer).position() + data.numValues > this.targetElementsPerPage) {
            if (force) {
                if (((Buffer)this.buffer).limit() < data.numValues) {
                    this.resizeBuffer(data.numValues);
                }
            } else {
                return false;
            }
        }
        this.copyToBuffer(data);
        this.repeatCounts.put(data.numValues);
        return true;
    }

    abstract void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<ENCODED_COLUMN_TYPE> var1);

    abstract void resizeBuffer(int var1);
}

