/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import gnu.trove.map.hash.TObjectIntHashMap;
import io.deephaven.parquet.table.DictionarySizeExceededException;
import java.util.Arrays;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.io.api.Binary;

public final class StringDictionary {
    private static final int INITIAL_DICTIONARY_SIZE = 256;
    private final int maxKeys;
    private final int maxDictSize;
    private final Statistics<?> statistics;
    private final int nullPos;
    private final TObjectIntHashMap<String> keyToPos;
    private Binary[] encodedKeys;
    private int keyCount;
    private int dictSize;

    public StringDictionary(int maxKeys, int maxDictSize, Statistics<?> statistics, int nullPos) {
        this.maxKeys = maxKeys;
        this.maxDictSize = maxDictSize;
        this.statistics = statistics;
        this.nullPos = nullPos;
        int NO_ENTRY_VALUE = -1;
        this.keyToPos = new TObjectIntHashMap(10, 0.5f, -1);
        this.encodedKeys = new Binary[Math.min(256, maxKeys)];
        this.keyCount = 0;
        this.dictSize = 0;
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public Binary[] getEncodedKeys() {
        return this.encodedKeys;
    }

    public int add(String key) {
        if (key == null) {
            return this.nullPos;
        }
        int posInDictionary = this.keyToPos.get((Object)key);
        if (posInDictionary == this.keyToPos.getNoEntryValue()) {
            if (this.keyCount == this.encodedKeys.length) {
                if (this.keyCount == this.maxKeys) {
                    throw new DictionarySizeExceededException("Dictionary maximum keys exceeded");
                }
                this.encodedKeys = Arrays.copyOf(this.encodedKeys, (int)Math.min((long)this.keyCount * 2L, (long)this.maxKeys));
            }
            Binary encodedKey = Binary.fromString((String)key);
            this.dictSize += encodedKey.length();
            if (this.dictSize > this.maxDictSize) {
                throw new DictionarySizeExceededException("Dictionary maximum size exceeded");
            }
            this.encodedKeys[this.keyCount] = encodedKey;
            this.statistics.updateStats(encodedKey);
            posInDictionary = this.keyCount++;
            this.keyToPos.put((Object)key, posInDictionary);
        }
        return posInDictionary;
    }
}

