/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.time.DateTimeUtils;
import java.nio.LongBuffer;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;

final class TimeArrayTransfer
extends PrimitiveArrayAndVectorTransfer<LocalTime[], LocalTime[], LongBuffer> {
    TimeArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, LongBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    int getSize(LocalTime @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = LongBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<LocalTime[]> data) {
        for (LocalTime t : (LocalTime[])data.encodedValues) {
            ((LongBuffer)this.buffer).put(DateTimeUtils.nanosOfDay((LocalTime)t));
        }
    }
}

