/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.vector.ObjectVector;
import java.nio.LongBuffer;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;

final class TimeVectorTransfer
extends PrimitiveVectorTransfer<ObjectVector<LocalTime>, LongBuffer> {
    TimeVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, LongBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = LongBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<ObjectVector<LocalTime>> data) {
        try (CloseableIterator dataIterator = ((ObjectVector)data.encodedValues).iterator();){
            dataIterator.forEachRemaining(t -> ((LongBuffer)this.buffer).put(DateTimeUtils.nanosOfDay((LocalTime)t)));
        }
    }
}

