/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.impl.CodecLookup;
import io.deephaven.engine.table.impl.sources.ReinterpretUtils;
import io.deephaven.engine.util.BigDecimalUtils;
import io.deephaven.parquet.base.BigDecimalParquetBytesCodec;
import io.deephaven.parquet.base.BigIntegerParquetBytesCodec;
import io.deephaven.parquet.table.ParquetCacheTags;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.TypeInfos;
import io.deephaven.parquet.table.transfer.BooleanArrayTransfer;
import io.deephaven.parquet.table.transfer.BooleanTransfer;
import io.deephaven.parquet.table.transfer.BooleanVectorTransfer;
import io.deephaven.parquet.table.transfer.ByteArrayTransfer;
import io.deephaven.parquet.table.transfer.ByteTransfer;
import io.deephaven.parquet.table.transfer.ByteVectorTransfer;
import io.deephaven.parquet.table.transfer.CharArrayTransfer;
import io.deephaven.parquet.table.transfer.CharTransfer;
import io.deephaven.parquet.table.transfer.CharVectorTransfer;
import io.deephaven.parquet.table.transfer.CodecArrayTransfer;
import io.deephaven.parquet.table.transfer.CodecTransfer;
import io.deephaven.parquet.table.transfer.CodecVectorTransfer;
import io.deephaven.parquet.table.transfer.DateArrayTransfer;
import io.deephaven.parquet.table.transfer.DateTransfer;
import io.deephaven.parquet.table.transfer.DateVectorTransfer;
import io.deephaven.parquet.table.transfer.DictEncodedStringArrayTransfer;
import io.deephaven.parquet.table.transfer.DictEncodedStringTransfer;
import io.deephaven.parquet.table.transfer.DictEncodedStringVectorTransfer;
import io.deephaven.parquet.table.transfer.DoubleArrayTransfer;
import io.deephaven.parquet.table.transfer.DoubleTransfer;
import io.deephaven.parquet.table.transfer.DoubleVectorTransfer;
import io.deephaven.parquet.table.transfer.FloatArrayTransfer;
import io.deephaven.parquet.table.transfer.FloatTransfer;
import io.deephaven.parquet.table.transfer.FloatVectorTransfer;
import io.deephaven.parquet.table.transfer.InstantArrayTransfer;
import io.deephaven.parquet.table.transfer.InstantVectorTransfer;
import io.deephaven.parquet.table.transfer.IntArrayTransfer;
import io.deephaven.parquet.table.transfer.IntTransfer;
import io.deephaven.parquet.table.transfer.IntVectorTransfer;
import io.deephaven.parquet.table.transfer.LocalDateTimeArrayTransfer;
import io.deephaven.parquet.table.transfer.LocalDateTimeTransfer;
import io.deephaven.parquet.table.transfer.LocalDateTimeVectorTransfer;
import io.deephaven.parquet.table.transfer.LongArrayTransfer;
import io.deephaven.parquet.table.transfer.LongTransfer;
import io.deephaven.parquet.table.transfer.LongVectorTransfer;
import io.deephaven.parquet.table.transfer.ShortArrayTransfer;
import io.deephaven.parquet.table.transfer.ShortTransfer;
import io.deephaven.parquet.table.transfer.ShortVectorTransfer;
import io.deephaven.parquet.table.transfer.StringArrayTransfer;
import io.deephaven.parquet.table.transfer.StringDictionary;
import io.deephaven.parquet.table.transfer.StringTransfer;
import io.deephaven.parquet.table.transfer.StringVectorTransfer;
import io.deephaven.parquet.table.transfer.TimeArrayTransfer;
import io.deephaven.parquet.table.transfer.TimeTransfer;
import io.deephaven.parquet.table.transfer.TimeVectorTransfer;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.codec.ObjectCodec;
import io.deephaven.vector.Vector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.IntBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TransferObject<BUFFER_TYPE>
extends SafeCloseable {
    public static <DATA_TYPE> TransferObject<?> create(@NotNull RowSet tableRowSet, @NotNull ParquetInstructions instructions, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull String columnName, @NotNull ColumnSource<DATA_TYPE> columnSource) {
        Class columnType = columnSource.getType();
        if (columnType == Integer.TYPE) {
            return IntTransfer.create(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Long.TYPE) {
            return LongTransfer.create(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Instant.class) {
            ColumnSource longColumnSource = ReinterpretUtils.instantToLongSource(columnSource);
            return LongTransfer.create(longColumnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Double.TYPE) {
            return DoubleTransfer.create(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Float.TYPE) {
            return FloatTransfer.create(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Boolean.class) {
            ColumnSource byteColumnSource = ReinterpretUtils.booleanToByteSource(columnSource);
            return BooleanTransfer.create(byteColumnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Short.TYPE) {
            return new ShortTransfer(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Character.TYPE) {
            return new CharTransfer(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == Byte.TYPE) {
            return new ByteTransfer(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == String.class) {
            return new StringTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
        }
        if (CodecLookup.explicitCodecPresent((String)instructions.getCodecName(columnName))) {
            ObjectCodec codec = CodecLookup.lookup((Class)columnType, (String)instructions.getCodecName(columnName), (String)instructions.getCodecArgs(columnName));
            return new CodecTransfer(columnSource, codec, (RowSequence)tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == BigDecimal.class) {
            ColumnSource bigDecimalColumnSource = columnSource;
            BigDecimalUtils.PrecisionAndScale precisionAndScale = TypeInfos.getPrecisionAndScale(computedCache, columnName, tableRowSet, () -> bigDecimalColumnSource);
            BigDecimalParquetBytesCodec codec = new BigDecimalParquetBytesCodec(precisionAndScale.precision, precisionAndScale.scale);
            return new CodecTransfer(bigDecimalColumnSource, codec, (RowSequence)tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == BigInteger.class) {
            return new CodecTransfer(columnSource, new BigIntegerParquetBytesCodec(), (RowSequence)tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == LocalDate.class) {
            return new DateTransfer(columnSource, tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == LocalTime.class) {
            return new TimeTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
        }
        if (columnType == LocalDateTime.class) {
            return new LocalDateTimeTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
        }
        @Nullable Class componentType = columnSource.getComponentType();
        if (columnType.isArray()) {
            if (componentType == Integer.TYPE) {
                return new IntArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Long.TYPE) {
                return new LongArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Double.TYPE) {
                return new DoubleArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Float.TYPE) {
                return new FloatArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Boolean.class) {
                return new BooleanArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Short.TYPE) {
                return new ShortArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Character.TYPE) {
                return new CharArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Byte.TYPE) {
                return new ByteArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == String.class) {
                return new StringArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == BigInteger.class) {
                return new CodecArrayTransfer(columnSource, new BigIntegerParquetBytesCodec(), (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Instant.class) {
                return new InstantArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == LocalDate.class) {
                return new DateArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == LocalTime.class) {
                return new TimeArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == LocalDateTime.class) {
                return new LocalDateTimeArrayTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
        }
        if (Vector.class.isAssignableFrom(columnType)) {
            if (componentType == Integer.TYPE) {
                return new IntVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Long.TYPE) {
                return new LongVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Double.TYPE) {
                return new DoubleVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Float.TYPE) {
                return new FloatVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Boolean.class) {
                return new BooleanVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Short.TYPE) {
                return new ShortVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Character.TYPE) {
                return new CharVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Byte.TYPE) {
                return new ByteVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == String.class) {
                return new StringVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == BigInteger.class) {
                return new CodecVectorTransfer(columnSource, new BigIntegerParquetBytesCodec(), (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == Instant.class) {
                return new InstantVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == LocalDate.class) {
                return new DateVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == LocalTime.class) {
                return new TimeVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
            if (componentType == LocalDateTime.class) {
                return new LocalDateTimeVectorTransfer(columnSource, (RowSequence)tableRowSet, instructions.getTargetPageSize());
            }
        }
        ObjectCodec codec = CodecLookup.getDefaultCodec((Class)columnType);
        return new CodecTransfer(columnSource, codec, (RowSequence)tableRowSet, instructions.getTargetPageSize());
    }

    @NotNull
    public static <DATA_TYPE> TransferObject<IntBuffer> createDictEncodedStringTransfer(@NotNull RowSet tableRowSet, @NotNull ColumnSource<DATA_TYPE> columnSource, int targetPageSize, @NotNull StringDictionary dictionary) {
        @Nullable Class dataType = columnSource.getType();
        @Nullable Class componentType = columnSource.getComponentType();
        if (dataType == String.class) {
            return new DictEncodedStringTransfer(columnSource, (RowSequence)tableRowSet, targetPageSize, dictionary);
        }
        if (dataType.isArray() && componentType == String.class) {
            return new DictEncodedStringArrayTransfer(columnSource, (RowSequence)tableRowSet, targetPageSize, dictionary);
        }
        if (Vector.class.isAssignableFrom(dataType) && componentType == String.class) {
            return new DictEncodedStringVectorTransfer(columnSource, (RowSequence)tableRowSet, targetPageSize, dictionary);
        }
        throw new UnsupportedOperationException("Dictionary encoding not supported for type " + dataType.getName());
    }

    public int transferOnePageToBuffer();

    public boolean hasMoreDataToBuffer();

    public BUFFER_TYPE getBuffer();

    default public boolean pageHasNull() {
        throw new UnsupportedOperationException("Only supported for dictionary encoded string transfer objects");
    }

    default public IntBuffer getRepeatCount() {
        throw new UnsupportedOperationException("Only supported for array and vector transfer objects");
    }
}

