/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.TransferObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class VariableWidthTransfer<COLUMN_TYPE, ENCODED_COLUMN_TYPE, BUFFER_TYPE>
implements TransferObject<BUFFER_TYPE> {
    private ObjectChunk<COLUMN_TYPE, Values> chunk;
    private final ColumnSource<?> columnSource;
    private final RowSequence.Iterator tableRowSetIt;
    private final ChunkSource.GetContext context;
    private final int targetPageSizeInBytes;
    private int currentChunkIdx;
    private final EncodedData<ENCODED_COLUMN_TYPE> encodedData;
    @Nullable
    private boolean cached;
    BUFFER_TYPE buffer;
    final int targetElementsPerPage;

    VariableWidthTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetElementsPerPage, int targetPageSizeInBytes, @NotNull BUFFER_TYPE buffer) {
        this.columnSource = columnSource;
        this.tableRowSetIt = tableRowSet.getRowSequenceIterator();
        this.targetPageSizeInBytes = Require.gtZero((int)targetPageSizeInBytes, (String)"targetPageSizeInBytes");
        this.targetElementsPerPage = Require.gtZero((int)targetElementsPerPage, (String)"targetElementsPerPage");
        this.context = columnSource.makeGetContext(Math.toIntExact(Math.min((long)targetElementsPerPage, tableRowSet.size())));
        this.currentChunkIdx = 0;
        this.buffer = buffer;
        this.encodedData = new EncodedData();
        this.cached = false;
    }

    @Override
    public final BUFFER_TYPE getBuffer() {
        return this.buffer;
    }

    @Override
    public final boolean hasMoreDataToBuffer() {
        return this.tableRowSetIt.hasMore() || this.chunk != null;
    }

    final void transferOnePageToBufferHelper() {
        block0: do {
            if (this.chunk == null) {
                RowSequence rs = this.tableRowSetIt.getNextRowSequenceWithLength((long)this.targetElementsPerPage);
                this.chunk = (ObjectChunk)this.columnSource.getChunk(this.context, rs);
                this.currentChunkIdx = 0;
            }
            int chunkSize = this.chunk.size();
            while (this.currentChunkIdx < chunkSize) {
                Object data = this.chunk.get(this.currentChunkIdx);
                if (data == null) {
                    if (!this.addNullToBuffer()) break block0;
                    ++this.currentChunkIdx;
                    continue;
                }
                if (!this.cached) {
                    this.encodeDataForBuffering(data, this.encodedData);
                }
                if (this.isBufferEmpty()) {
                    this.addEncodedDataToBuffer(this.encodedData, true);
                } else if (this.getNumBytesBuffered() + this.encodedData.numBytes > this.targetPageSizeInBytes || !this.addEncodedDataToBuffer(this.encodedData, false)) {
                    this.cached = true;
                    break block0;
                }
                this.cached = false;
                ++this.currentChunkIdx;
            }
            if (this.currentChunkIdx != this.chunk.size()) continue;
            this.chunk = null;
        } while (this.tableRowSetIt.hasMore());
    }

    abstract boolean addNullToBuffer();

    abstract void encodeDataForBuffering(@NotNull COLUMN_TYPE var1, @NotNull EncodedData<ENCODED_COLUMN_TYPE> var2);

    abstract boolean addEncodedDataToBuffer(@NotNull EncodedData<ENCODED_COLUMN_TYPE> var1, boolean var2);

    abstract int getNumBytesBuffered();

    abstract boolean isBufferEmpty();

    public final void close() {
        this.context.close();
        this.tableRowSetIt.close();
    }

    static final class EncodedData<E> {
        E encodedValues;
        int numValues;
        int numBytes;

        EncodedData() {
        }

        void fillSingle(@NotNull E encodedValues, int numBytes) {
            this.fillInternal(encodedValues, numBytes, 1);
        }

        void fillRepeated(@NotNull E data, int numBytes, int numValues) {
            this.fillInternal(data, numBytes, numValues);
        }

        private void fillInternal(@NotNull E encodedValues, int numBytes, int numValues) {
            this.encodedValues = encodedValues;
            this.numBytes = numBytes;
            this.numValues = numValues;
        }
    }
}

