/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.table.impl.util;

import com.google.common.collect.Sets;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.hierarchical.TreeTable;
import io.deephaven.engine.table.impl.util.EngineMetrics;
import io.deephaven.engine.table.impl.util.RuntimeMemory;
import io.deephaven.engine.util.TableTools;
import io.deephaven.plot.Figure;
import io.deephaven.plot.PlottingConvenience;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PerformanceQueriesGeneral {
    private static final boolean FORMAT_PCT_COLUMNS = true;
    private static final Set<String> ALLOWED_MISSING_COLUMN_NAMES = Sets.newHashSet((Object[])new String[]{"ProcessUniqueId", "ParentEvaluationNumber", "ParentOperationNumber"});

    public static Table queryPerformance(Table queryPerformanceLog, long evaluationNumber) {
        if (evaluationNumber != Long.MIN_VALUE) {
            queryPerformanceLog = (Table)queryPerformanceLog.where(new String[]{PerformanceQueriesGeneral.whereConditionForEvaluationNumber(evaluationNumber)});
        }
        long workerHeapSizeBytes = PerformanceQueriesGeneral.getWorkerHeapSizeBytes();
        queryPerformanceLog = (Table)queryPerformanceLog.updateView(new String[]{"WorkerHeapSize = " + workerHeapSizeBytes + "L", "DurationNanos = EndTime - StartTime", "TimeSecs = nanosToMillis(DurationNanos) / 1000d", "NetMemoryChange = FreeMemoryChange - TotalMemoryChange", "QueryMemUsed = TotalMemory - FreeMemory", "QueryMemUsedPct = QueryMemUsed / WorkerHeapSize", "QueryMemFree = WorkerHeapSize - QueryMemUsed"});
        queryPerformanceLog = PerformanceQueriesGeneral.maybeMoveColumnsUp(queryPerformanceLog, "ProcessUniqueId", "EvaluationNumber", "ParentEvaluationNumber", "QueryMemUsed", "QueryMemFree", "QueryMemUsedPct", "EndTime", "TimeSecs", "NetMemoryChange");
        queryPerformanceLog = PerformanceQueriesGeneral.formatColumnsAsPct(queryPerformanceLog, "QueryMemUsedPct");
        return queryPerformanceLog;
    }

    public static Table queryPerformance(Table queryPerformanceLog) {
        return PerformanceQueriesGeneral.queryPerformance(queryPerformanceLog, Long.MIN_VALUE);
    }

    public static Table queryOperationPerformance(Table queryOps, long evaluationNumber) {
        if (evaluationNumber != Long.MIN_VALUE) {
            queryOps = (Table)queryOps.where(new String[]{PerformanceQueriesGeneral.whereConditionForEvaluationNumber(evaluationNumber)});
        }
        queryOps = (Table)queryOps.updateView(new String[]{"DurationNanos = EndTime - StartTime", "TimeSecs = nanosToMillis(DurationNanos) / 1000d", "NetMemoryChange = FreeMemoryChange - TotalMemoryChange"});
        return PerformanceQueriesGeneral.maybeMoveColumnsUp(queryOps, "ProcessUniqueId", "EvaluationNumber", "ParentEvaluationNumber", "OperationNumber", "ParentOperationNumber", "EndTime", "TimeSecs", "NetMemoryChange");
    }

    public static Table queryOperationPerformance(Table queryOps) {
        return PerformanceQueriesGeneral.queryOperationPerformance(queryOps, Long.MIN_VALUE);
    }

    public static String processInfo(Table processInfo, String processInfoId, String type, String key) {
        processInfo = (Table)((Table)processInfo.where(new String[]{"Id = `" + processInfoId + "`", "Type = `" + type + "`", "Key = `" + key + "`"})).select(new String[]{"Value"});
        return (String)processInfo.getColumnSource("Value").get(processInfo.getRowSet().firstRowKey());
    }

    public static Table queryUpdatePerformance(Table queryUpdatePerformance, long evaluationNumber, boolean formatPctColumnsLocal) {
        if (evaluationNumber != Long.MIN_VALUE) {
            queryUpdatePerformance = (Table)queryUpdatePerformance.where(new String[]{PerformanceQueriesGeneral.whereConditionForEvaluationNumber(evaluationNumber)});
        }
        long workerHeapSizeBytes = PerformanceQueriesGeneral.getWorkerHeapSizeBytes();
        queryUpdatePerformance = (Table)queryUpdatePerformance.updateView(new String[]{"IntervalDurationNanos = IntervalEndTime - IntervalStartTime", "WorkerHeapSize = " + workerHeapSizeBytes + "L", "Ratio = UsageNanos / IntervalDurationNanos", "QueryMemUsed = MaxTotalMemory - MinFreeMemory", "QueryMemUsedPct = QueryMemUsed / WorkerHeapSize", "QueryMemFree = WorkerHeapSize - QueryMemUsed", "NRows = RowsAdded + RowsRemoved + RowsModified", "RowsPerSec = round(NRows / IntervalDurationNanos * 1.0e9)", "RowsPerCPUSec = round(NRows / UsageNanos * 1.0e9)"});
        queryUpdatePerformance = PerformanceQueriesGeneral.maybeMoveColumnsUp(queryUpdatePerformance, "ProcessUniqueId", "EvaluationNumber", "OperationNumber", "Ratio", "QueryMemUsed", "QueryMemUsedPct", "IntervalEndTime", "RowsPerSec", "RowsPerCPUSec", "EntryDescription");
        if (formatPctColumnsLocal) {
            queryUpdatePerformance = PerformanceQueriesGeneral.formatColumnsAsPctUpdatePerformance(queryUpdatePerformance);
        }
        return queryUpdatePerformance;
    }

    public static Table queryUpdatePerformance(Table queryUpdatePerformance) {
        return PerformanceQueriesGeneral.queryUpdatePerformance(queryUpdatePerformance, Long.MIN_VALUE, true);
    }

    public static Map<String, Table> queryUpdatePerformanceMap(Table queryUpdatePerformance, long evaluationNumber) {
        HashMap<String, Table> resultMap = new HashMap<String, Table>();
        Table qup = (Table)PerformanceQueriesGeneral.queryUpdatePerformance(queryUpdatePerformance, evaluationNumber, false).updateView(new String[]{"IntervalDurationNanos = IntervalEndTime - IntervalStartTime"});
        Table worstInterval = (Table)((Table)((Table)((Table)((Table)qup.groupBy(new String[]{"IntervalStartTime", "IntervalDurationNanos"})).sort(new String[]{"IntervalDurationNanos"})).tail(1L)).ungroup()).view(new String[]{"IntervalStartTime", "IntervalEndTime", "EntryId", "EntryDescription", "IntervalDurationNanos", "Ratio", "UsageNanos", "RowsAdded", "RowsRemoved", "RowsModified", "RowsShifted", "NRows"});
        Table updateWorst = (Table)qup.sortDescending(new String[]{"Ratio"});
        Table updateMostRecent = ((Table)updateWorst.sortDescending(new String[]{"IntervalEndTime"})).moveColumnsUp(new String[]{"IntervalEndTime"});
        String[] groupByColumns = qup.hasColumns(new String[]{"ProcessUniqueId"}) ? new String[]{"IntervalStartTime", "IntervalEndTime", "ProcessUniqueId"} : new String[]{"IntervalStartTime", "IntervalEndTime"};
        Table updateAggregate = ((Table)((Table)qup.aggBy(Arrays.asList(Aggregation.AggSum((String[])new String[]{"NRows", "UsageNanos"}), Aggregation.AggFirst((String[])new String[]{"QueryMemUsed", "WorkerHeapSize", "QueryMemUsedPct", "IntervalDurationNanos"})), groupByColumns)).updateView(new String[]{"Ratio = UsageNanos / IntervalDurationNanos"})).moveColumnsUp(new String[]{"IntervalStartTime", "IntervalEndTime", "Ratio"});
        Table updateSummaryStats = (Table)updateAggregate.aggBy(Arrays.asList(Aggregation.AggPct((double)0.99, (String[])new String[]{"Ratio_99_Percentile = Ratio", "QueryMemUsedPct_99_Percentile = QueryMemUsedPct"}), Aggregation.AggPct((double)0.9, (String[])new String[]{"Ratio_90_Percentile = Ratio", "QueryMemUsedPct_90_Percentile = QueryMemUsedPct"}), Aggregation.AggPct((double)0.75, (String[])new String[]{"Ratio_75_Percentile = Ratio", "QueryMemUsedPct_75_Percentile = QueryMemUsedPct"}), Aggregation.AggPct((double)0.5, (String[])new String[]{"Ratio_50_Percentile = Ratio", "QueryMemUsedPct_50_Percentile = QueryMemUsedPct"}), Aggregation.AggMax((String[])new String[]{"Ratio_Max = Ratio", "QueryMemUsedPct_Max = QueryMemUsedPct"})));
        qup = PerformanceQueriesGeneral.formatColumnsAsPctUpdatePerformance(qup);
        worstInterval = PerformanceQueriesGeneral.formatColumnsAsPct(worstInterval, "Ratio");
        updateWorst = PerformanceQueriesGeneral.formatColumnsAsPctUpdatePerformance(updateWorst);
        updateMostRecent = PerformanceQueriesGeneral.formatColumnsAsPctUpdatePerformance(updateMostRecent);
        updateAggregate = PerformanceQueriesGeneral.formatColumnsAsPctUpdatePerformance(updateAggregate);
        updateSummaryStats = PerformanceQueriesGeneral.formatColumnsAsPct(updateSummaryStats, "Ratio_99_Percentile", "QueryMemUsedPct_99_Percentile", "Ratio_90_Percentile", "QueryMemUsedPct_90_Percentile", "Ratio_75_Percentile", "QueryMemUsedPct_75_Percentile", "Ratio_50_Percentile", "QueryMemUsedPct_50_Percentile", "Ratio_Max", "QueryMemUsedPct_Max");
        resultMap.put("QueryUpdatePerformance", qup);
        resultMap.put("WorstInterval", worstInterval);
        resultMap.put("UpdateWorst", updateWorst);
        resultMap.put("UpdateMostRecent", updateMostRecent);
        resultMap.put("UpdateAggregate", updateAggregate);
        resultMap.put("UpdateSummaryStats", updateSummaryStats);
        return resultMap;
    }

    public static Map<String, Table> queryUpdatePerformanceMap(Table queryUpdatePerformance) {
        return PerformanceQueriesGeneral.queryUpdatePerformanceMap(queryUpdatePerformance, Long.MIN_VALUE);
    }

    public static float approxRatio(long v0, long v1) {
        if (v1 == 0L || v0 == Long.MIN_VALUE || v1 == Long.MIN_VALUE) {
            return -3.4028235E38f;
        }
        float pct = (float)v0 / (float)v1;
        return Math.min(pct, 1.0f);
    }

    public static Table serverState(Table pml) {
        long maxMemoryBytes = RuntimeMemory.getInstance().maxMemory();
        int maxMemoryMiB = (int)Math.ceil((double)maxMemoryBytes / 1048576.0);
        pml = (Table)pml.updateView(new String[]{"MaxMemMiB = " + maxMemoryMiB});
        Table pm = (Table)pml.view(new String[]{"IntervalStart = IntervalStartTime", "IntervalSecs = IntervalDurationMicros / (1000 * 1000.0)", "IntervalEnd = IntervalStart + IntervalDurationMicros * 1000", "UsedMemMiB = TotalMemoryMiB - FreeMemoryMiB", "AvailMemMiB = MaxMemMiB - TotalMemoryMiB + FreeMemoryMiB", "MaxMemMiB", "AvailMemRatio = AvailMemMiB/MaxMemMiB", "UsedMemRatio = UsedMemMiB/MaxMemMiB", "GcTimeRatio = io.deephaven.engine.table.impl.util.PerformanceQueriesGeneral.approxRatio(IntervalCollectionTimeMicros, IntervalDurationMicros)", "UGPCycles = count(IntervalUGPCyclesTimeMicros)", "UGPOnBudgetRatio = io.deephaven.engine.table.impl.util.PerformanceQueriesGeneral.approxRatio(IntervalUGPCyclesOnBudget, IntervalUGPCyclesTimeMicros.length)", "UGPCycleMaxSecs = max(IntervalUGPCyclesTimeMicros) / (1000 * 1000.0)", "UGPCycleMedianSecs = median(IntervalUGPCyclesTimeMicros) / (1000 * 1000.0)", "UGPCycleMeanSecs = avg(IntervalUGPCyclesTimeMicros) / (1000 * 1000.0)", "UGPCycleP90Secs = percentile(0.9, IntervalUGPCyclesTimeMicros) / (1000 * 1000.0)", "UGPTimeRatio = io.deephaven.engine.table.impl.util.PerformanceQueriesGeneral.approxRatio(sum(IntervalUGPCyclesTimeMicros), IntervalDurationMicros)", "UGPSafePointTimeRatio = io.deephaven.engine.table.impl.util.PerformanceQueriesGeneral.approxRatio(IntervalUGPCyclesSafePointTimeMicros, IntervalDurationMicros)"});
        pm = pm.formatColumns(new String[]{"AvailMemRatio=Decimal(`#0.0%`)", "AvailMemRatio=(AvailMemRatio < 0.05) ? PALE_RED : ((AvailMemRatio < 0.10) ? PALE_REDPURPLE : ((AvailMemRatio < 0.20) ? PALE_PURPLE : NO_FORMATTING))", "UGPOnBudgetRatio=Decimal(`#0.0%`)", "UGPTimeRatio=Decimal(`#0.0%`)", "UGPSafePointTimeRatio=Decimal(`#0.0%`)", "GcTimeRatio=Decimal(`#0.0%`)", "GcTimeRatio=(GcTimeRatio >= 0.75) ? PALE_RED : ((GcTimeRatio >= 0.50) ? PALE_REDPURPLE : ((GcTimeRatio > 0.05) ? PALE_PURPLE : NO_FORMATTING))", "UGPOnBudgetRatio=(UGPOnBudgetRatio < 0.05) ? PALE_RED : ((UGPOnBudgetRatio < 0.10) ? PALE_REDPURPLE : ((UGPOnBudgetRatio < 0.20) ? PALE_PURPLE : NO_FORMATTING))", "UGPTimeRatio=(UGPTimeRatio >= 0.99) ? PALE_RED : ((UGPTimeRatio >= 0.95) ? PALE_REDPURPLE : ((UGPTimeRatio > 0.90) ? PALE_PURPLE : NO_FORMATTING))", "UGPSafePointTimeRatio=(UGPSafePointTimeRatio >= 0.75) ? PALE_RED : ((UGPSafePointTimeRatio >= 0.50) ? PALE_REDPURPLE : ((UGPSafePointTimeRatio > 0.05) ? PALE_PURPLE : NO_FORMATTING))", "IntervalSecs=Decimal(`#0.000`)"});
        return pm;
    }

    public static Map<String, Object> serverStateWithPlots(Table pml) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Table pm = PerformanceQueriesGeneral.serverState(pml);
        resultMap.put("ServerState", pm);
        int maxMemMiB = pm.getColumnSource("MaxMemMiB").getInt(pm.getRowSet().firstRowKey());
        if (maxMemMiB == Integer.MIN_VALUE) {
            maxMemMiB = 4096;
        }
        Figure serverStateTimeline = PlottingConvenience.newChart().chartTitle("Performance").plot((Comparable)((Object)"UGPRatio"), pm, "IntervalEnd", "UGPTimeRatio").yMin(0.0).yMax(1.0).yLabel("UGPRatio").twinX().plot((Comparable)((Object)"Memory Usage MiB"), pm, "IntervalEnd", "UsedMemMiB").yMin(0.0).yMax((double)maxMemMiB).yLabel("Mem Usage MiB").twinX().plot((Comparable)((Object)"Memory Usage %"), pm, "IntervalEnd", "UsedMemRatio").yMin(0.0).yMax(1.0).yLabel("Mem Usage %").show();
        resultMap.put("ServerStateTimeLine", serverStateTimeline);
        Figure ugpCycleTimeline = PlottingConvenience.newChart().chartTitle("Update Graph Processor Cycles").newAxes().yLabel("Cycle Time (s)").xLabel("Timestamp").plot((Comparable)((Object)"Max"), pm, "IntervalEnd", "UGPCycleMaxSecs").plot((Comparable)((Object)"90th Percentile"), pm, "IntervalEnd", "UGPCycleP90Secs").plot((Comparable)((Object)"Median"), pm, "IntervalEnd", "UGPCycleMedianSecs").plot((Comparable)((Object)"Average"), pm, "IntervalEnd", "UGPCycleMeanSecs").show();
        resultMap.put("UGPCycleTimeline", ugpCycleTimeline);
        return resultMap;
    }

    public static TreeTable queryPerformanceAsTreeTable(@NotNull Table qpl) {
        return qpl.tree("EvaluationNumber", "ParentEvaluationNumber");
    }

    public static TreeTable queryOperationPerformanceAsTreeTable(@NotNull Table qpl, @NotNull Table qopl) {
        Table mergeWithAggKeys = TableTools.merge((Table[])new Table[]{(Table)qpl.updateView(new String[]{"EvalKey = Long.toString(EvaluationNumber)", "ParentEvalKey = ParentEvaluationNumber == null ? null : (Long.toString(ParentEvaluationNumber))", "OperationNumber = NULL_INT", "ParentOperationNumber = NULL_INT", "Depth = NULL_INT", "CallerLine = (String) null", "IsCompilation = NULL_BOOLEAN", "InputSizeLong = NULL_LONG"}), (Table)qopl.updateView(new String[]{"EvalKey = EvaluationNumber + `:` + OperationNumber", "ParentEvalKey = EvaluationNumber + (ParentOperationNumber == null ? `` : (`:` + ParentOperationNumber))", "Exception = (String) null"})}).moveColumnsUp(new String[]{"EvalKey", "ParentEvalKey"}).moveColumnsDown(new String[]{"EvaluationNumber", "ParentEvaluationNumber", "OperationNumber", "ParentOperationNumber"});
        return mergeWithAggKeys.tree("EvalKey", "ParentEvalKey");
    }

    private static Table formatColumnsAsPct(Table t, String ... cols) {
        String[] formats = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            formats[i] = cols[i] + "=Decimal(`#0.00%`)";
        }
        return t.formatColumns(formats);
    }

    private static Table formatColumnsAsPctUpdatePerformance(Table updatePerformanceTable) {
        return PerformanceQueriesGeneral.formatColumnsAsPct(updatePerformanceTable, "Ratio", "QueryMemUsedPct");
    }

    private static long getWorkerHeapSizeBytes() {
        return EngineMetrics.getProcessInfo().getMemoryInfo().heap().max().orElse(0L);
    }

    private static String whereConditionForEvaluationNumber(long evaluationNumber) {
        return "EvaluationNumber = " + evaluationNumber;
    }

    private static Table maybeMoveColumnsUp(Table source, String ... cols) {
        return source.moveColumnsUp((String[])Stream.of(cols).filter(columnName -> !ALLOWED_MISSING_COLUMN_NAMES.contains(columnName) || source.hasColumns(new String[]{columnName})).toArray(String[]::new));
    }
}

