/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.protobuf;

import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;

class Box<T>
implements TypedFunction.Visitor<T, Object>,
ToPrimitiveFunction.Visitor<T, Object> {
    private final T value;

    public static <T> Object apply(TypedFunction<T> f, T value) {
        return f.walk(new Box<T>(value));
    }

    public static <T> Object apply(ToPrimitiveFunction<T> f, T value) {
        return f.walk(new Box<T>(value));
    }

    private Box(T value) {
        this.value = value;
    }

    public Object visit(ToObjectFunction<T, ?> f) {
        return f.apply(this.value);
    }

    public Object visit(ToPrimitiveFunction<T> f) {
        return f.walk((ToPrimitiveFunction.Visitor)this);
    }

    public Boolean visit(ToBooleanFunction<T> f) {
        return f.test(this.value);
    }

    public Character visit(ToCharFunction<T> f) {
        return Character.valueOf(f.applyAsChar(this.value));
    }

    public Byte visit(ToByteFunction<T> f) {
        return f.applyAsByte(this.value);
    }

    public Short visit(ToShortFunction<T> f) {
        return f.applyAsShort(this.value);
    }

    public Integer visit(ToIntFunction<T> f) {
        return f.applyAsInt(this.value);
    }

    public Long visit(ToLongFunction<T> f) {
        return f.applyAsLong(this.value);
    }

    public Float visit(ToFloatFunction<T> f) {
        return Float.valueOf(f.applyAsFloat(this.value));
    }

    public Double visit(ToDoubleFunction<T> f) {
        return f.applyAsDouble(this.value);
    }
}

