/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.protobuf;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.protobuf.FieldOptions;
import io.deephaven.protobuf.FieldPath;
import io.deephaven.protobuf.MessageParser;
import io.deephaven.protobuf.MessageParserSingle;
import io.deephaven.protobuf.ProtobufDescriptorParserOptions;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.Type;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

class Builtin {
    Builtin() {
    }

    static List<MessageParser> parsers() {
        return List.of(TimestampParser.of(), DurationParser.of(), BoolValueParser.of(), Int32ValueParser.of(), UInt32ValueParser.of(), Int64ValueParser.of(), UInt64ValueParser.of(), FloatValueParser.of(), DoubleValueParser.of(), StringValueParser.of(), BytesValueParser.of(), Builtin.customParser(Any.class), Builtin.customParser(FieldMask.class));
    }

    static <T extends Message> MessageParserSingle customParser(Class<T> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getDescriptor", new Class[0]);
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)method.invoke(null, new Object[0]);
            return new GenericSVMP(CustomType.of(clazz), descriptor);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkCompatible(Descriptors.Descriptor expected, Descriptors.Descriptor actual) {
        String actualName;
        String expectedName = expected.getFullName();
        if (!expectedName.equals(actualName = actual.getFullName())) {
            throw new IllegalArgumentException(String.format("Incompatible descriptors, expected=%s, actual=%s", expectedName, actualName));
        }
    }

    private static void checkCompatible(Descriptors.FieldDescriptor.JavaType expected, Descriptors.FieldDescriptor actual) {
        if (!expected.equals((Object)actual.getJavaType())) {
            throw new IllegalArgumentException(String.format("Incompatible field type, expected=%s, actual=%s (%s)", expected, actual.getJavaType(), actual.getFullName()));
        }
    }

    private static final class ByteStringFieldFunction
    implements ToObjectFunction<Message, ByteString> {
        private static final CustomType<ByteString> RETURN_TYPE = Type.ofCustom(ByteString.class);
        private final Descriptors.FieldDescriptor valueField;

        public ByteStringFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public GenericType<ByteString> returnType() {
            return RETURN_TYPE;
        }

        public ByteString apply(Message value) {
            return (ByteString)value.getField(this.valueField);
        }
    }

    private static final class StringFieldFunction
    implements ToObjectFunction<Message, String> {
        private final Descriptors.FieldDescriptor valueField;

        public StringFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.STRING, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public GenericType<String> returnType() {
            return Type.stringType();
        }

        public String apply(Message value) {
            return (String)value.getField(this.valueField);
        }
    }

    private static final class DoubleFieldFunction
    implements ToDoubleFunction<Message> {
        private final Descriptors.FieldDescriptor valueField;

        public DoubleFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.DOUBLE, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public double applyAsDouble(Message value) {
            return (Double)value.getField(this.valueField);
        }
    }

    private static final class FloatFieldFunction
    implements ToFloatFunction<Message> {
        private final Descriptors.FieldDescriptor valueField;

        public FloatFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.FLOAT, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public float applyAsFloat(Message value) {
            return ((Float)value.getField(this.valueField)).floatValue();
        }
    }

    private static final class LongFieldFunction
    implements ToLongFunction<Message> {
        private final Descriptors.FieldDescriptor valueField;

        public LongFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.LONG, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public long applyAsLong(Message value) {
            return (Long)value.getField(this.valueField);
        }
    }

    private static final class IntFieldFunction
    implements ToIntFunction<Message> {
        private final Descriptors.FieldDescriptor valueField;

        public IntFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.INT, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public int applyAsInt(Message value) {
            return (Integer)value.getField(this.valueField);
        }
    }

    private static final class BoolFieldFunction
    implements ToBooleanFunction<Message> {
        private final Descriptors.FieldDescriptor valueField;

        public BoolFieldFunction(Descriptors.FieldDescriptor valueField) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.BOOLEAN, valueField);
            this.valueField = Objects.requireNonNull(valueField);
        }

        public boolean test(Message value) {
            return (Boolean)value.getField(this.valueField);
        }
    }

    private static final class DurationFunction
    implements ToObjectFunction<Message, java.time.Duration> {
        private static final GenericType<java.time.Duration> RETURN_TYPE = Type.ofCustom(java.time.Duration.class);
        private final Descriptors.FieldDescriptor seconds;
        private final Descriptors.FieldDescriptor nanos;

        public static ToObjectFunction<Message, java.time.Duration> of(Descriptors.Descriptor descriptor) {
            Descriptors.FieldDescriptor secondsField = descriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor nanosField = descriptor.findFieldByNumber(2);
            return new DurationFunction(secondsField, nanosField);
        }

        private DurationFunction(Descriptors.FieldDescriptor seconds, Descriptors.FieldDescriptor nanos) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.LONG, seconds);
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.INT, nanos);
            this.seconds = Objects.requireNonNull(seconds);
            this.nanos = Objects.requireNonNull(nanos);
        }

        public GenericType<java.time.Duration> returnType() {
            return RETURN_TYPE;
        }

        public java.time.Duration apply(Message value) {
            return java.time.Duration.ofSeconds((Long)value.getField(this.seconds), ((Integer)value.getField(this.nanos)).intValue());
        }
    }

    private static final class TimestampFunction
    implements ToObjectFunction<Message, Instant> {
        private final Descriptors.FieldDescriptor seconds;
        private final Descriptors.FieldDescriptor nanos;

        public static ToObjectFunction<Message, Instant> of(Descriptors.Descriptor descriptor) {
            Descriptors.FieldDescriptor secondsField = descriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor nanosField = descriptor.findFieldByNumber(2);
            return new TimestampFunction(secondsField, nanosField);
        }

        private TimestampFunction(Descriptors.FieldDescriptor seconds, Descriptors.FieldDescriptor nanos) {
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.LONG, seconds);
            Builtin.checkCompatible(Descriptors.FieldDescriptor.JavaType.INT, nanos);
            this.seconds = Objects.requireNonNull(seconds);
            this.nanos = Objects.requireNonNull(nanos);
        }

        public GenericType<Instant> returnType() {
            return Type.instantType();
        }

        public Instant apply(Message value) {
            return Instant.ofEpochSecond((Long)value.getField(this.seconds), ((Integer)value.getField(this.nanos)).intValue());
        }
    }

    private static class GenericSVMP<T extends Message>
    implements MessageParserSingle {
        private final GenericType<T> type;
        private final Descriptors.Descriptor descriptor;

        public GenericSVMP(GenericType<T> type, Descriptors.Descriptor descriptor) {
            this.type = Objects.requireNonNull(type);
            this.descriptor = Objects.requireNonNull(descriptor);
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return this.descriptor;
        }

        public ToObjectFunction<Message, T> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return ToObjectFunction.identity(this.type);
        }
    }

    private static enum BytesValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToObjectFunction<Message, ByteString> CANONICAL_FUNCTION_BYTESTRING;
        private static final ToObjectFunction<ByteString, byte[]> BYTESTRING_TO_BYTES;
        private static final ToObjectFunction<Message, byte[]> CANONICAL_FUNCTION_BYTEARRAY;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return BytesValue.getDescriptor();
        }

        public ToObjectFunction<Message, ?> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            boolean asByteArray;
            boolean bl = asByteArray = options.fieldOptions().apply(fieldPath).bytes() == FieldOptions.BytesBehavior.asByteArray();
            if (this.canonicalDescriptor() == descriptor) {
                return asByteArray ? CANONICAL_FUNCTION_BYTEARRAY : CANONICAL_FUNCTION_BYTESTRING;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            ByteStringFieldFunction bsf = new ByteStringFieldFunction(descriptor.findFieldByNumber(1));
            return asByteArray ? bsf.mapToObj(BYTESTRING_TO_BYTES) : bsf;
        }

        static {
            CANONICAL_FUNCTION_BYTESTRING = ToObjectFunction.identity((GenericType)Type.ofCustom(BytesValue.class)).mapToObj(BytesValue::getValue, (GenericType)Type.ofCustom(ByteString.class));
            BYTESTRING_TO_BYTES = ToObjectFunction.of(ByteString::toByteArray, (GenericType)Type.byteType().arrayType());
            CANONICAL_FUNCTION_BYTEARRAY = CANONICAL_FUNCTION_BYTESTRING.mapToObj(BYTESTRING_TO_BYTES);
        }
    }

    private static enum StringValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToObjectFunction<Message, String> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return StringValue.getDescriptor();
        }

        public ToObjectFunction<Message, String> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new StringFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(StringValue.class)).mapToObj(StringValue::getValue, (GenericType)Type.stringType());
        }
    }

    private static enum DoubleValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToDoubleFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return DoubleValue.getDescriptor();
        }

        public ToDoubleFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new DoubleFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(DoubleValue.class)).mapToDouble(DoubleValue::getValue);
        }
    }

    private static enum FloatValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToFloatFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return FloatValue.getDescriptor();
        }

        public ToFloatFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new FloatFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(FloatValue.class)).mapToFloat(FloatValue::getValue);
        }
    }

    private static enum UInt64ValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToLongFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return UInt64Value.getDescriptor();
        }

        public ToLongFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new LongFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(UInt64Value.class)).mapToLong(UInt64Value::getValue);
        }
    }

    private static enum Int64ValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToLongFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return Int64Value.getDescriptor();
        }

        public ToLongFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new LongFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(Int64Value.class)).mapToLong(Int64Value::getValue);
        }
    }

    private static enum UInt32ValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToIntFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return UInt32Value.getDescriptor();
        }

        public ToIntFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new IntFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(UInt32Value.class)).mapToInt(UInt32Value::getValue);
        }
    }

    private static enum Int32ValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToIntFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return Int32Value.getDescriptor();
        }

        public ToIntFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new IntFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(Int32Value.class)).mapToInt(Int32Value::getValue);
        }
    }

    private static enum BoolValueParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToBooleanFunction<Message> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return BoolValue.getDescriptor();
        }

        public ToBooleanFunction<Message> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return new BoolFieldFunction(descriptor.findFieldByNumber(1));
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(BoolValue.class)).mapToBoolean(BoolValue::getValue);
        }
    }

    private static enum DurationParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToObjectFunction<Message, java.time.Duration> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        private static java.time.Duration parseCanonical(Duration duration) {
            return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return Duration.getDescriptor();
        }

        public ToObjectFunction<Message, java.time.Duration> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return DurationFunction.of(descriptor);
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(Duration.class)).mapToObj(DurationParser::parseCanonical, (GenericType)Type.ofCustom(java.time.Duration.class));
        }
    }

    private static enum TimestampParser implements MessageParserSingle
    {
        INSTANCE;

        private static final ToObjectFunction<Message, Instant> CANONICAL_FUNCTION;

        public static MessageParserSingle of() {
            return INSTANCE;
        }

        private static Instant parseCanonical(Timestamp timestamp) {
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }

        @Override
        public Descriptors.Descriptor canonicalDescriptor() {
            return Timestamp.getDescriptor();
        }

        public ToObjectFunction<Message, Instant> messageParser(Descriptors.Descriptor descriptor, ProtobufDescriptorParserOptions options, FieldPath fieldPath) {
            if (this.canonicalDescriptor() == descriptor) {
                return CANONICAL_FUNCTION;
            }
            Builtin.checkCompatible(this.canonicalDescriptor(), descriptor);
            return TimestampFunction.of(descriptor);
        }

        static {
            CANONICAL_FUNCTION = ToObjectFunction.identity((GenericType)Type.ofCustom(Timestamp.class)).mapToObj(TimestampParser::parseCanonical, (GenericType)Type.instantType());
        }
    }
}

