/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.protobuf;

import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.GenericType;

enum BypassOnNull implements TypedFunction.Visitor<Object, TypedFunction<Object>>,
ToPrimitiveFunction.Visitor<Object, TypedFunction<Object>>
{
    INSTANCE;


    private static <T> TypedFunction.Visitor<T, TypedFunction<T>> visitor() {
        return INSTANCE;
    }

    private static <T> ToPrimitiveFunction.Visitor<T, TypedFunction<T>> primitiveVisitor() {
        return INSTANCE;
    }

    public static <T> TypedFunction<T> of(TypedFunction<T> x) {
        return (TypedFunction)x.walk(BypassOnNull.visitor());
    }

    public static <T> TypedFunction<T> of(ToPrimitiveFunction<T> x) {
        return (TypedFunction)x.walk(BypassOnNull.primitiveVisitor());
    }

    public static <T, R> ToObjectFunction<T, R> of(ToObjectFunction<T, R> f) {
        return ToObjectFunction.of(x -> BypassOnNull.apply(f, x), (GenericType)f.returnType());
    }

    public static <T> ToObjectFunction<T, Boolean> of(ToBooleanFunction<T> f) {
        return ToObjectFunction.of(x -> BypassOnNull.applyAsBoolean(f, x), (GenericType)BoxedBooleanType.of());
    }

    public static <T> ToCharFunction<T> of(ToCharFunction<T> f) {
        return x -> BypassOnNull.applyAsChar(f, x);
    }

    public static <T> ToByteFunction<T> of(ToByteFunction<T> f) {
        return x -> BypassOnNull.applyAsByte(f, x);
    }

    public static <T> ToShortFunction<T> of(ToShortFunction<T> f) {
        return x -> BypassOnNull.applyAsShort(f, x);
    }

    public static <T> ToIntFunction<T> of(ToIntFunction<T> f) {
        return x -> BypassOnNull.applyAsInt(f, x);
    }

    public static <T> ToLongFunction<T> of(ToLongFunction<T> f) {
        return x -> BypassOnNull.applyAsLong(f, x);
    }

    public static <T> ToFloatFunction<T> of(ToFloatFunction<T> f) {
        return x -> BypassOnNull.applyAsFloat(f, x);
    }

    public static <T> ToDoubleFunction<T> of(ToDoubleFunction<T> f) {
        return x -> BypassOnNull.applyAsDouble(f, x);
    }

    public ToObjectFunction<Object, ?> visit(ToObjectFunction<Object, ?> f) {
        return BypassOnNull.of(f);
    }

    public TypedFunction<Object> visit(ToPrimitiveFunction<Object> f) {
        return (TypedFunction)f.walk((ToPrimitiveFunction.Visitor)this);
    }

    public ToObjectFunction<Object, Boolean> visit(ToBooleanFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToCharFunction<Object> visit(ToCharFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToByteFunction<Object> visit(ToByteFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToShortFunction<Object> visit(ToShortFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToIntFunction<Object> visit(ToIntFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToLongFunction<Object> visit(ToLongFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToFloatFunction<Object> visit(ToFloatFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    public ToDoubleFunction<Object> visit(ToDoubleFunction<Object> f) {
        return BypassOnNull.of(f);
    }

    private static <T, R> R apply(ToObjectFunction<T, R> f, T x) {
        return (R)(x == null ? null : f.apply(x));
    }

    private static <T> Boolean applyAsBoolean(ToBooleanFunction<T> f, T x) {
        return x == null ? null : Boolean.valueOf(f.test(x));
    }

    private static <T> char applyAsChar(ToCharFunction<T> f, T x) {
        return x == null ? (char)'\uffff' : f.applyAsChar(x);
    }

    private static <T> byte applyAsByte(ToByteFunction<T> f, T x) {
        return x == null ? (byte)-128 : f.applyAsByte(x);
    }

    private static <T> short applyAsShort(ToShortFunction<T> f, T x) {
        return x == null ? (short)Short.MIN_VALUE : f.applyAsShort(x);
    }

    private static <T> int applyAsInt(ToIntFunction<T> f, T x) {
        return x == null ? Integer.MIN_VALUE : f.applyAsInt(x);
    }

    private static <T> long applyAsLong(ToLongFunction<T> f, T x) {
        return x == null ? Long.MIN_VALUE : f.applyAsLong(x);
    }

    private static <T> float applyAsFloat(ToFloatFunction<T> f, T x) {
        return x == null ? -3.4028235E38f : f.applyAsFloat(x);
    }

    private static <T> double applyAsDouble(ToDoubleFunction<T> f, T x) {
        return x == null ? -1.7976931348623157E308 : f.applyAsDouble(x);
    }
}

