/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.protobuf;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.protobuf.FieldPath;
import io.deephaven.protobuf.ImmutableFieldOptions;
import java.util.function.Function;
import java.util.function.Predicate;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class FieldOptions {
    private static final FieldOptions DEFAULTS = FieldOptions.builder().build();
    private static final FieldOptions EXCLUDE = FieldOptions.builder().include(false).build();

    public static Builder builder() {
        return ImmutableFieldOptions.builder();
    }

    public static FieldOptions defaults() {
        return DEFAULTS;
    }

    public static FieldOptions exclude() {
        return EXCLUDE;
    }

    public static Function<FieldPath, FieldOptions> includeIf(Predicate<FieldPath> include) {
        return fp -> FieldOptions.builder().include(include.test((FieldPath)fp)).build();
    }

    @Value.Default
    public boolean include() {
        return true;
    }

    @Value.Default
    public WellKnownBehavior wellKnown() {
        return WellKnownBehavior.asWellKnown();
    }

    @Value.Default
    public BytesBehavior bytes() {
        return BytesBehavior.asByteArray();
    }

    @Value.Default
    public MapBehavior map() {
        return MapBehavior.asMap();
    }

    static enum MapsImpl implements MapBehavior
    {
        AS_MAP,
        AS_REPEATED;

    }

    static enum BytesImpl implements BytesBehavior
    {
        AS_BYTE_ARRAY,
        AS_BYTES_STRING;

    }

    static enum WellKnownImpl implements WellKnownBehavior
    {
        AS_WELL_KNOWN,
        AS_RECURSIVE;

    }

    public static interface Builder {
        public Builder include(boolean var1);

        public Builder wellKnown(WellKnownBehavior var1);

        public Builder bytes(BytesBehavior var1);

        public Builder map(MapBehavior var1);

        public FieldOptions build();
    }

    public static interface MapBehavior {
        public static MapBehavior asMap() {
            return MapsImpl.AS_MAP;
        }

        public static MapBehavior asRepeated() {
            return MapsImpl.AS_REPEATED;
        }
    }

    public static interface BytesBehavior {
        public static BytesBehavior asByteArray() {
            return BytesImpl.AS_BYTE_ARRAY;
        }

        public static BytesBehavior asByteString() {
            return BytesImpl.AS_BYTES_STRING;
        }
    }

    public static interface WellKnownBehavior {
        public static WellKnownBehavior asWellKnown() {
            return WellKnownImpl.AS_WELL_KNOWN;
        }

        public static WellKnownBehavior asRecursive() {
            return WellKnownImpl.AS_RECURSIVE;
        }
    }
}

