/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.protobuf;

import com.google.protobuf.Descriptors;
import io.deephaven.annotations.SimpleStyle;
import io.deephaven.function.ToBooleanFunction;
import io.deephaven.protobuf.FieldNumberPath;
import io.deephaven.protobuf.ImmutableFieldPath;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class FieldPath {
    private static final FieldPath EMPTY = FieldPath.of(List.of());

    public static FieldPath empty() {
        return EMPTY;
    }

    public static FieldPath of(Descriptors.FieldDescriptor ... descriptors) {
        return FieldPath.of(Arrays.asList(descriptors));
    }

    public static FieldPath of(List<Descriptors.FieldDescriptor> descriptors) {
        return ImmutableFieldPath.of(descriptors);
    }

    public static ToBooleanFunction<FieldPath> matches(String simplePath) {
        simplePath = !simplePath.isEmpty() && simplePath.charAt(0) == '/' ? simplePath.substring(1) : simplePath;
        List<String> np = Arrays.asList(simplePath.split("/"));
        boolean star = !np.isEmpty() && "*".equals(np.get(np.size() - 1));
        List<String> namePath = star ? np.subList(0, np.size() - 1) : np;
        ToBooleanFunction leadingUpToMatch = fieldPath -> fieldPath.otherStartsWithThis(namePath);
        if (!star) {
            return leadingUpToMatch;
        }
        ToBooleanFunction starMatch = fieldPath -> fieldPath.startsWith(namePath);
        return ToBooleanFunction.or(List.of(leadingUpToMatch, starMatch));
    }

    public static ToBooleanFunction<FieldPath> anyMatches(List<String> simplePaths) {
        return ToBooleanFunction.or((Collection)simplePaths.stream().map(FieldPath::matches).collect(Collectors.toList()));
    }

    @Value.Parameter
    public abstract List<Descriptors.FieldDescriptor> path();

    @Value.Lazy
    public FieldNumberPath numberPath() {
        return FieldNumberPath.of(this.path().stream().mapToInt(Descriptors.FieldDescriptor::getNumber).toArray());
    }

    @Value.Lazy
    public List<String> namePath() {
        return this.path().stream().map(Descriptors.FieldDescriptor::getName).collect(Collectors.toList());
    }

    public final boolean startsWith(List<String> prefix) {
        return FieldPath.startsWith(this.namePath(), prefix);
    }

    public final boolean otherStartsWithThis(List<String> other) {
        return FieldPath.startsWith(other, this.namePath());
    }

    private static boolean startsWith(List<String> x, List<String> prefix) {
        return x.subList(0, Math.min(prefix.size(), x.size())).equals(prefix);
    }
}

