/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.protobuf.Box;
import io.deephaven.protobuf.BypassOnNull;
import io.deephaven.protobuf.FieldOptions;
import io.deephaven.protobuf.FieldPath;
import io.deephaven.protobuf.MessageParser;
import io.deephaven.protobuf.ProtobufDescriptorParserOptions;
import io.deephaven.protobuf.ProtobufFunction;
import io.deephaven.protobuf.ProtobufFunctions;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.BoxedDoubleType;
import io.deephaven.qst.type.BoxedFloatType;
import io.deephaven.qst.type.BoxedIntType;
import io.deephaven.qst.type.BoxedLongType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.Type;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProtobufDescriptorParserImpl {
    private static final ToObjectFunction<Object, String> STRING_OBJ = ToObjectFunction.identity((GenericType)Type.stringType());
    private static final ToObjectFunction<Object, Integer> BOXED_INT_OBJ = ToObjectFunction.identity((GenericType)BoxedIntType.of());
    private static final ToObjectFunction<Object, Long> BOXED_LONG_OBJ = ToObjectFunction.identity((GenericType)BoxedLongType.of());
    private static final ToObjectFunction<Object, Float> BOXED_FLOAT_OBJ = ToObjectFunction.identity((GenericType)BoxedFloatType.of());
    private static final ToObjectFunction<Object, Double> BOXED_DOUBLE_OBJ = ToObjectFunction.identity((GenericType)BoxedDoubleType.of());
    private static final ToObjectFunction<Object, Boolean> BOXED_BOOLEAN_OBJ = ToObjectFunction.identity((GenericType)BoxedBooleanType.of());
    private static final ToObjectFunction<Object, Message> MESSAGE_OBJ = ToObjectFunction.identity((GenericType)Type.ofCustom(Message.class));
    private static final ToObjectFunction<Object, ByteString> BYTE_STRING_OBJ = ToObjectFunction.identity((GenericType)Type.ofCustom(ByteString.class));
    private static final ToObjectFunction<Object, Descriptors.EnumValueDescriptor> ENUM_VALUE_DESCRIPTOR_OBJ = ToObjectFunction.identity((GenericType)Type.ofCustom(Descriptors.EnumValueDescriptor.class));
    private static final ToObjectFunction<ByteString, byte[]> BYTE_STRING_FUNCTION = BypassOnNull.of(ToObjectFunction.of(ByteString::toByteArray, (GenericType)Type.byteType().arrayType()));
    private final ProtobufDescriptorParserOptions options;
    private final Map<String, MessageParser> byFullName;

    public ProtobufDescriptorParserImpl(ProtobufDescriptorParserOptions options) {
        this.options = Objects.requireNonNull(options);
        this.byFullName = options.parsers().stream().collect(Collectors.toMap(x -> x.canonicalDescriptor().getFullName(), Function.identity()));
    }

    public ProtobufFunctions translate(Descriptors.Descriptor descriptor) {
        return new DescriptorContext(FieldPath.empty(), descriptor).functions();
    }

    private static char[] toChars(Message message, Descriptors.FieldDescriptor fd, ToCharFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        char[] array = new char[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsChar(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static byte[] toBytes(Message message, Descriptors.FieldDescriptor fd, ToByteFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        byte[] array = new byte[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsByte(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static short[] toShorts(Message message, Descriptors.FieldDescriptor fd, ToShortFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        short[] array = new short[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsShort(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static int[] toInts(Message message, Descriptors.FieldDescriptor fd, ToIntFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsInt(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static long[] toLongs(Message message, Descriptors.FieldDescriptor fd, ToLongFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsLong(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static float[] toFloats(Message message, Descriptors.FieldDescriptor fd, ToFloatFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        float[] array = new float[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsFloat(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static double[] toDoubles(Message message, Descriptors.FieldDescriptor fd, io.deephaven.function.ToDoubleFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        double[] array = new double[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.applyAsDouble(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static boolean[] toBooleans(Message message, Descriptors.FieldDescriptor fd, ToBooleanFunction<Object> f) {
        int count = message.getRepeatedFieldCount(fd);
        boolean[] array = new boolean[count];
        for (int i = 0; i < count; ++i) {
            array[i] = f.test(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static <T> T[] toArray(Message message, Descriptors.FieldDescriptor fd, ToObjectFunction<Object, T> f) {
        int count = message.getRepeatedFieldCount(fd);
        Object[] array = (Object[])Array.newInstance(f.returnType().clazz(), count);
        for (int i = 0; i < count; ++i) {
            array[i] = f.apply(message.getRepeatedField(fd, i));
        }
        return array;
    }

    private static FieldPath prepend(FieldPath f, Descriptors.FieldDescriptor fd) {
        return FieldPath.of(Stream.concat(Stream.of(fd), f.path().stream()).collect(Collectors.toList()));
    }

    private static FieldPath append(FieldPath f, Descriptors.FieldDescriptor fd) {
        return FieldPath.of(Stream.concat(f.path().stream(), Stream.of(fd)).collect(Collectors.toList()));
    }

    private class FieldContext {
        private final DescriptorContext parent;
        private final Descriptors.FieldDescriptor fd;
        private final FieldPath fieldPath;

        public FieldContext(DescriptorContext parent, Descriptors.FieldDescriptor fd) {
            this.parent = Objects.requireNonNull(parent);
            this.fd = Objects.requireNonNull(fd);
            this.fieldPath = ProtobufDescriptorParserImpl.append(parent.fieldPath, fd);
        }

        private ProtobufFunctions functions() {
            return this.functions(false);
        }

        private ProtobufFunctions functions(boolean forceInclude) {
            FieldOptions fo = ProtobufDescriptorParserImpl.this.options.fieldOptions().apply(this.fieldPath);
            if (!forceInclude && !fo.include()) {
                return ProtobufFunctions.empty();
            }
            if (this.fd.isMapField() && fo.map() == FieldOptions.MapBehavior.asMap()) {
                return new MapFieldObject().functions();
            }
            if (this.fd.isRepeated()) {
                return new RepeatedFieldObject().functions();
            }
            return new FieldObject().functions();
        }

        private ProtobufFunctions namedField(TypedFunction<Message> tf) {
            return ProtobufFunctions.of(ProtobufFunction.of(FieldPath.of(this.fd), tf));
        }

        private DescriptorContext toMessageContext() {
            if (this.fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new IllegalStateException();
            }
            return new DescriptorContext(this.fieldPath, this.fd.getMessageType());
        }

        private class RepeatedFieldObject {
            private RepeatedFieldObject() {
            }

            private ProtobufFunctions functions() {
                switch (FieldContext.this.fd.getJavaType()) {
                    case INT: {
                        return this.namedField((TypedFunction<Message>)this.mapInts((ToIntFunction<Object>)ToIntFunction.cast()));
                    }
                    case LONG: {
                        return this.namedField((TypedFunction<Message>)this.mapLongs((ToLongFunction<Object>)ToLongFunction.cast()));
                    }
                    case FLOAT: {
                        return this.namedField((TypedFunction<Message>)this.mapFloats((ToFloatFunction<Object>)ToFloatFunction.cast()));
                    }
                    case DOUBLE: {
                        return this.namedField((TypedFunction<Message>)this.mapDoubles((io.deephaven.function.ToDoubleFunction<Object>)io.deephaven.function.ToDoubleFunction.cast()));
                    }
                    case BOOLEAN: {
                        return this.namedField((TypedFunction<Message>)this.mapBooleans((ToBooleanFunction<Object>)ToBooleanFunction.cast()));
                    }
                    case STRING: {
                        return this.namedField((TypedFunction<Message>)this.mapGenerics(STRING_OBJ));
                    }
                    case BYTE_STRING: {
                        return ProtobufDescriptorParserImpl.this.options.fieldOptions().apply(FieldContext.this.fieldPath).bytes() == FieldOptions.BytesBehavior.asByteArray() ? this.namedField((TypedFunction<Message>)this.mapGenerics(BYTE_STRING_OBJ.mapToObj(BYTE_STRING_FUNCTION))) : this.namedField((TypedFunction<Message>)this.mapGenerics(BYTE_STRING_OBJ));
                    }
                    case ENUM: {
                        return this.namedField((TypedFunction<Message>)this.mapGenerics(ENUM_VALUE_DESCRIPTOR_OBJ));
                    }
                    case MESSAGE: {
                        DescriptorContext messageContext = FieldContext.this.toMessageContext();
                        ProtobufFunctions functions = messageContext.functions();
                        ProtobufFunctions.Builder builder = ProtobufFunctions.builder();
                        for (ProtobufFunction f : functions.functions()) {
                            ToObjectFunction repeatedTf = (ToObjectFunction)f.function().walk((TypedFunction.Visitor)new ToRepeatedType());
                            builder.addFunctions(ProtobufFunction.of(ProtobufDescriptorParserImpl.prepend(f.path(), FieldContext.this.fd), (TypedFunction<Message>)repeatedTf));
                        }
                        return builder.build();
                    }
                }
                throw new IllegalStateException();
            }

            private ToObjectFunction<Message, char[]> mapChars(ToCharFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toChars(m, FieldContext.this.fd, f), (GenericType)Type.charType().arrayType());
            }

            private ToObjectFunction<Message, byte[]> mapBytes(ToByteFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toBytes(m, FieldContext.this.fd, f), (GenericType)Type.byteType().arrayType());
            }

            private ToObjectFunction<Message, short[]> mapShorts(ToShortFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toShorts(m, FieldContext.this.fd, f), (GenericType)Type.shortType().arrayType());
            }

            private ToObjectFunction<Message, int[]> mapInts(ToIntFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toInts(m, FieldContext.this.fd, f), (GenericType)Type.intType().arrayType());
            }

            private ToObjectFunction<Message, long[]> mapLongs(ToLongFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toLongs(m, FieldContext.this.fd, f), (GenericType)Type.longType().arrayType());
            }

            private ToObjectFunction<Message, float[]> mapFloats(ToFloatFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toFloats(m, FieldContext.this.fd, f), (GenericType)Type.floatType().arrayType());
            }

            private ToObjectFunction<Message, double[]> mapDoubles(io.deephaven.function.ToDoubleFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toDoubles(m, FieldContext.this.fd, f), (GenericType)Type.doubleType().arrayType());
            }

            private ToObjectFunction<Message, boolean[]> mapBooleans(ToBooleanFunction<Object> f) {
                return ToObjectFunction.of(m -> ProtobufDescriptorParserImpl.toBooleans(m, FieldContext.this.fd, f), (GenericType)Type.booleanType().arrayType());
            }

            private <T> ToObjectFunction<Message, T[]> mapGenerics(ToObjectFunction<Object, T> f) {
                return ToObjectFunction.of(message -> ProtobufDescriptorParserImpl.toArray(message, FieldContext.this.fd, f), (GenericType)f.returnType().arrayType());
            }

            private ProtobufFunctions namedField(TypedFunction<Message> tf) {
                return ProtobufFunctions.of(ProtobufFunction.of(FieldPath.of(FieldContext.this.fd), tf));
            }

            private class ToRepeatedType
            implements TypedFunction.Visitor<Message, ToObjectFunction<Message, ?>>,
            ToPrimitiveFunction.Visitor<Message, ToObjectFunction<Message, ?>> {
                private ToRepeatedType() {
                }

                public ToObjectFunction<Message, ?> visit(ToObjectFunction<Message, ?> f) {
                    return RepeatedFieldObject.this.mapGenerics(MESSAGE_OBJ.mapToObj(f));
                }

                public ToObjectFunction<Message, ?> visit(ToPrimitiveFunction<Message> f) {
                    return (ToObjectFunction)f.walk((ToPrimitiveFunction.Visitor)this);
                }

                public ToObjectFunction<Message, boolean[]> visit(ToBooleanFunction<Message> f) {
                    return RepeatedFieldObject.this.mapBooleans((ToBooleanFunction<Object>)MESSAGE_OBJ.mapToBoolean(f));
                }

                public ToObjectFunction<Message, char[]> visit(ToCharFunction<Message> f) {
                    return RepeatedFieldObject.this.mapChars((ToCharFunction<Object>)MESSAGE_OBJ.mapToChar(f));
                }

                public ToObjectFunction<Message, byte[]> visit(ToByteFunction<Message> f) {
                    return RepeatedFieldObject.this.mapBytes((ToByteFunction<Object>)MESSAGE_OBJ.mapToByte(f));
                }

                public ToObjectFunction<Message, short[]> visit(ToShortFunction<Message> f) {
                    return RepeatedFieldObject.this.mapShorts((ToShortFunction<Object>)MESSAGE_OBJ.mapToShort(f));
                }

                public ToObjectFunction<Message, int[]> visit(ToIntFunction<Message> f) {
                    return RepeatedFieldObject.this.mapInts((ToIntFunction<Object>)MESSAGE_OBJ.mapToInt(f));
                }

                public ToObjectFunction<Message, long[]> visit(ToLongFunction<Message> f) {
                    return RepeatedFieldObject.this.mapLongs((ToLongFunction<Object>)MESSAGE_OBJ.mapToLong(f));
                }

                public ToObjectFunction<Message, float[]> visit(ToFloatFunction<Message> f) {
                    return RepeatedFieldObject.this.mapFloats((ToFloatFunction<Object>)MESSAGE_OBJ.mapToFloat(f));
                }

                public ToObjectFunction<Message, double[]> visit(io.deephaven.function.ToDoubleFunction<Message> f) {
                    return RepeatedFieldObject.this.mapDoubles((io.deephaven.function.ToDoubleFunction<Object>)MESSAGE_OBJ.mapToDouble(f));
                }
            }
        }

        private class MapFieldObject {
            private MapFieldObject() {
            }

            private ProtobufFunctions functions() {
                if (FieldContext.this.fd.getMessageType().getFields().size() != 2) {
                    throw new IllegalStateException("Expected map to have exactly 2 field descriptors");
                }
                Descriptors.FieldDescriptor keyFd = FieldContext.this.fd.getMessageType().findFieldByNumber(1);
                if (keyFd == null) {
                    throw new IllegalStateException("Expected map to have field descriptor number 1 (key)");
                }
                Descriptors.FieldDescriptor valueFd = FieldContext.this.fd.getMessageType().findFieldByNumber(2);
                if (valueFd == null) {
                    throw new IllegalStateException("Expected map to have field descriptor number 2 (value)");
                }
                DescriptorContext dc = new DescriptorContext(ProtobufDescriptorParserImpl.append(FieldContext.this.parent.fieldPath, FieldContext.this.fd), FieldContext.this.fd.getMessageType());
                ProtobufFunctions keyFunctions = new FieldContext(dc, keyFd).functions(true);
                if (keyFunctions.functions().size() != 1) {
                    throw new IllegalStateException("Protobuf map keys must be a single type");
                }
                ProtobufFunctions valueFunctions = new FieldContext(dc, valueFd).functions(true);
                if (valueFunctions.functions().size() != 1) {
                    return this.delegate();
                }
                TypedFunction<Message> keyFunction = keyFunctions.functions().get(0).function();
                TypedFunction<Message> valueFunction = valueFunctions.functions().get(0).function();
                return FieldContext.this.namedField((TypedFunction<Message>)ToObjectFunction.of(message -> {
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    int count = message.getRepeatedFieldCount(FieldContext.this.fd);
                    for (int i = 0; i < count; ++i) {
                        Message obj = (Message)message.getRepeatedField(FieldContext.this.fd, i);
                        Object key = Box.apply(keyFunction, obj);
                        Object value = Box.apply(valueFunction, obj);
                        map.put(key, value);
                    }
                    return map;
                }, (GenericType)Type.ofCustom(Map.class)));
            }

            private ProtobufFunctions delegate() {
                return new RepeatedFieldObject().functions();
            }
        }

        private class FieldObject
        implements ToObjectFunction<Message, Object> {
            private FieldObject() {
            }

            public GenericType<Object> returnType() {
                return Type.ofCustom(Object.class);
            }

            public Object apply(Message message) {
                if (message == null) {
                    return null;
                }
                if (FieldContext.this.fd.hasPresence() && !message.hasField(FieldContext.this.fd)) {
                    return null;
                }
                return message.getField(FieldContext.this.fd);
            }

            private ProtobufFunctions functions() {
                switch (FieldContext.this.fd.getJavaType()) {
                    case INT: {
                        return FieldContext.this.fd.hasPresence() ? FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BOXED_INT_OBJ)) : FieldContext.this.namedField((TypedFunction<Message>)this.mapToInt((java.util.function.ToIntFunction)ToIntFunction.cast()));
                    }
                    case LONG: {
                        return FieldContext.this.fd.hasPresence() ? FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BOXED_LONG_OBJ)) : FieldContext.this.namedField((TypedFunction<Message>)this.mapToLong((java.util.function.ToLongFunction)ToLongFunction.cast()));
                    }
                    case FLOAT: {
                        return FieldContext.this.fd.hasPresence() ? FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BOXED_FLOAT_OBJ)) : FieldContext.this.namedField((TypedFunction<Message>)this.mapToFloat(ToFloatFunction.cast()));
                    }
                    case DOUBLE: {
                        return FieldContext.this.fd.hasPresence() ? FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BOXED_DOUBLE_OBJ)) : FieldContext.this.namedField((TypedFunction<Message>)this.mapToDouble((ToDoubleFunction)io.deephaven.function.ToDoubleFunction.cast()));
                    }
                    case BOOLEAN: {
                        return FieldContext.this.fd.hasPresence() ? FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BOXED_BOOLEAN_OBJ)) : FieldContext.this.namedField((TypedFunction<Message>)this.mapToBoolean((Predicate)ToBooleanFunction.cast()));
                    }
                    case STRING: {
                        return FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(STRING_OBJ));
                    }
                    case BYTE_STRING: {
                        return ProtobufDescriptorParserImpl.this.options.fieldOptions().apply(FieldContext.this.fieldPath).bytes() == FieldOptions.BytesBehavior.asByteArray() ? FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BYTE_STRING_OBJ).mapToObj(BYTE_STRING_FUNCTION)) : FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(BYTE_STRING_OBJ));
                    }
                    case ENUM: {
                        return FieldContext.this.namedField((TypedFunction<Message>)this.mapToObj(ENUM_VALUE_DESCRIPTOR_OBJ));
                    }
                    case MESSAGE: {
                        ToObjectFunction fieldAsMessage = this.mapToObj(MESSAGE_OBJ);
                        DescriptorContext messageContext = FieldContext.this.toMessageContext();
                        ProtobufFunctions subF = messageContext.functions();
                        ProtobufFunctions.Builder builder = ProtobufFunctions.builder();
                        boolean parentFieldIsRepeated = !FieldContext.this.parent.fieldPath.path().isEmpty() && FieldContext.this.parent.fieldPath.path().get(FieldContext.this.parent.fieldPath.path().size() - 1).isRepeated();
                        for (ProtobufFunction e : subF.functions()) {
                            TypedFunction<Message> value = parentFieldIsRepeated ? e.function() : BypassOnNull.of(e.function());
                            builder.addFunctions(ProtobufFunction.of(ProtobufDescriptorParserImpl.prepend(e.path(), FieldContext.this.fd), (TypedFunction<Message>)fieldAsMessage.map(value)));
                        }
                        return builder.build();
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    private class DescriptorContext {
        private final FieldPath fieldPath;
        private final Descriptors.Descriptor descriptor;

        public DescriptorContext(FieldPath fieldPath, Descriptors.Descriptor descriptor) {
            this.fieldPath = Objects.requireNonNull(fieldPath);
            this.descriptor = Objects.requireNonNull(descriptor);
        }

        private ProtobufFunctions functions() {
            ProtobufFunctions wellKnown = this.wellKnown().orElse(null);
            if (wellKnown != null) {
                return wellKnown;
            }
            ProtobufFunctions.Builder builder = ProtobufFunctions.builder();
            for (FieldContext fc : this.fcs()) {
                builder.addAllFunctions(fc.functions().functions());
            }
            return builder.build();
        }

        private Optional<ProtobufFunctions> wellKnown() {
            MessageParser mp = ProtobufDescriptorParserImpl.this.byFullName.get(this.descriptor.getFullName());
            if (mp == null) {
                return Optional.empty();
            }
            if (ProtobufDescriptorParserImpl.this.options.fieldOptions().apply(this.fieldPath).wellKnown() == FieldOptions.WellKnownBehavior.asWellKnown()) {
                return Optional.of(mp.messageParsers(this.descriptor, ProtobufDescriptorParserImpl.this.options, this.fieldPath));
            }
            return Optional.empty();
        }

        private List<FieldContext> fcs() {
            return this.descriptor.getFields().stream().map(this::fc).collect(Collectors.toList());
        }

        private FieldContext fc(Descriptors.FieldDescriptor fd) {
            return new FieldContext(this, fd);
        }
    }
}

