/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.grpc;

import io.deephaven.grpc.AbstractMtlsClientCertificateInterceptor;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.ServerCall;
import io.grpc.ServerInterceptor;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class MTlsCertificate {
    private static final Logger logger = Logger.getLogger(MTlsCertificate.class.getName());
    public static final Context.Key<List<X509Certificate>> CLIENT_CERTIFICATES = Context.key((String)"mtls-client-certificates");
    public static final ServerInterceptor DEFAULT_INTERCEPTOR = new AbstractMtlsClientCertificateInterceptor(){

        @Override
        protected <ReqT, RespT> Optional<List<X509Certificate>> getTransportCertificates(ServerCall<ReqT, RespT> call) {
            SSLSession sslSession = (SSLSession)call.getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
            if (sslSession == null) {
                return Optional.empty();
            }
            try {
                Certificate[] javaxCerts = sslSession.getPeerCertificates();
                if (javaxCerts == null || javaxCerts.length == 0) {
                    return Optional.empty();
                }
                int length = javaxCerts.length;
                ArrayList<X509Certificate> javaCerts = new ArrayList<X509Certificate>(length);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                for (Certificate javaxCert : javaxCerts) {
                    byte[] bytes = javaxCert.getEncoded();
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    javaCerts.add((X509Certificate)cf.generateCertificate(stream));
                }
                return Optional.of(Collections.unmodifiableList(javaCerts));
            }
            catch (SSLPeerUnverifiedException pue) {
                return Optional.empty();
            }
            catch (CertificateException e) {
                logger.log(Level.WARNING, "Unable to read X509CertChain due to certificate exception", e);
                return Optional.empty();
            }
        }
    };
}

