/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.hotspot;

import io.deephaven.hotspot.HotSpot;

public class JvmIntrospectionContext {
    private final HotSpot hotspot = HotSpot.loadImpl().orElse(null);
    private long lastStartPausesCount = -1L;
    private long lastStartPausesTimeMillis = -1L;
    private long lastStartSyncTimeMillis = -1L;
    private long lastEndPausesCount;
    private long lastEndPausesTimeMillis;
    private long lastEndSyncTimeMillis;

    public boolean hasSafePointData() {
        return this.hotspot != null;
    }

    public void startSample() {
        if (this.hotspot == null) {
            return;
        }
        this.lastStartPausesCount = this.hotspot.getSafepointCount();
        this.lastStartPausesTimeMillis = this.hotspot.getTotalSafepointTimeMillis();
        this.lastStartSyncTimeMillis = this.hotspot.getSafepointSyncTimeMillis();
    }

    public void endSample() {
        if (this.hotspot == null) {
            return;
        }
        this.lastEndPausesCount = this.hotspot.getSafepointCount();
        this.lastEndPausesTimeMillis = this.hotspot.getTotalSafepointTimeMillis();
        this.lastEndSyncTimeMillis = this.hotspot.getSafepointSyncTimeMillis();
    }

    public long deltaSafePointPausesCount() {
        return this.lastEndPausesCount - this.lastStartPausesCount;
    }

    public long deltaSafePointPausesTimeMillis() {
        return this.lastEndPausesTimeMillis - this.lastStartPausesTimeMillis;
    }

    public long deltaSafePointSyncTimeMillis() {
        return this.lastEndSyncTimeMillis - this.lastStartSyncTimeMillis;
    }
}

