/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.qst.column.header.ColumnHeader;
import io.deephaven.qst.type.ArrayType;
import io.deephaven.qst.type.BooleanType;
import io.deephaven.qst.type.BoxedType;
import io.deephaven.qst.type.ByteType;
import io.deephaven.qst.type.CharType;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.DoubleType;
import io.deephaven.qst.type.FloatType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.InstantType;
import io.deephaven.qst.type.IntType;
import io.deephaven.qst.type.LongType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.ShortType;
import io.deephaven.qst.type.StringType;
import io.deephaven.qst.type.Type;
import java.util.Collections;
import java.util.Objects;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class FieldAdapter
implements Type.Visitor<Field>,
PrimitiveType.Visitor<Field> {
    private final String name;

    public static Field of(ColumnHeader<?> header) {
        return (Field)header.componentType().walk((Type.Visitor)new FieldAdapter(header.name()));
    }

    public static Field byteField(String name) {
        return FieldAdapter.field(name, Types.MinorType.TINYINT.getType(), "byte");
    }

    public static Field booleanField(String name) {
        return FieldAdapter.field(name, Types.MinorType.BIT.getType(), "boolean");
    }

    public static Field charField(String name) {
        return FieldAdapter.field(name, Types.MinorType.UINT2.getType(), "char");
    }

    public static Field shortField(String name) {
        return FieldAdapter.field(name, Types.MinorType.SMALLINT.getType(), "short");
    }

    public static Field intField(String name) {
        return FieldAdapter.field(name, Types.MinorType.INT.getType(), "int");
    }

    public static Field longField(String name) {
        return FieldAdapter.field(name, Types.MinorType.BIGINT.getType(), "long");
    }

    public static Field floatField(String name) {
        return FieldAdapter.field(name, Types.MinorType.FLOAT4.getType(), "float");
    }

    public static Field doubleField(String name) {
        return FieldAdapter.field(name, Types.MinorType.FLOAT8.getType(), "double");
    }

    public static Field stringField(String name) {
        return FieldAdapter.field(name, Types.MinorType.VARCHAR.getType(), "java.lang.String");
    }

    public static Field byteVectorField(String name) {
        return FieldAdapter.field(name, Types.MinorType.VARBINARY.getType(), "byte[]");
    }

    public static Field instantField(String name) {
        return FieldAdapter.field(name, (ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "UTC"), "java.time.Instant");
    }

    private static Field field(String name, ArrowType arrowType, String deephavenType) {
        return FieldAdapter.field(name, new FieldType(true, arrowType, null, Collections.singletonMap("deephaven:type", deephavenType)));
    }

    private static Field field(String name, FieldType type) {
        return new Field(name, type, null);
    }

    private FieldAdapter(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public Field visit(PrimitiveType<?> primitive) {
        return (Field)primitive.walk((PrimitiveType.Visitor)this);
    }

    public Field visit(GenericType<?> generic) {
        return (Field)generic.walk((GenericType.Visitor)new GenericType.Visitor<Field>(){

            public Field visit(BoxedType<?> boxedType) {
                return FieldAdapter.this.visit((PrimitiveType<?>)boxedType.primitiveType());
            }

            public Field visit(StringType stringType) {
                return FieldAdapter.stringField(FieldAdapter.this.name);
            }

            public Field visit(InstantType instantType) {
                return FieldAdapter.instantField(FieldAdapter.this.name);
            }

            public Field visit(ArrayType<?, ?> arrayType) {
                if (arrayType.componentType().equals(Type.find(Byte.TYPE))) {
                    return FieldAdapter.byteVectorField(FieldAdapter.this.name);
                }
                throw new UnsupportedOperationException();
            }

            public Field visit(CustomType<?> customType) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public Field visit(ByteType byteType) {
        return FieldAdapter.byteField(this.name);
    }

    public Field visit(BooleanType booleanType) {
        return FieldAdapter.booleanField(this.name);
    }

    public Field visit(CharType charType) {
        return FieldAdapter.charField(this.name);
    }

    public Field visit(ShortType shortType) {
        return FieldAdapter.shortField(this.name);
    }

    public Field visit(IntType intType) {
        return FieldAdapter.intField(this.name);
    }

    public Field visit(LongType longType) {
        return FieldAdapter.longField(this.name);
    }

    public Field visit(FloatType floatType) {
        return FieldAdapter.floatField(this.name);
    }

    public Field visit(DoubleType doubleType) {
        return FieldAdapter.doubleField(this.name);
    }
}

