/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.HasPathId;
import io.deephaven.client.impl.HasTicketId;
import io.deephaven.client.impl.VectorSchemaRootAdapter;
import io.deephaven.qst.table.NewTable;
import org.apache.arrow.flight.AsyncPutListener;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;

public class FlightClientHelper {
    public static FlightStream get(FlightClient client, HasTicketId ticket, CallOption ... callOptions) {
        return client.getStream(FlightClientHelper.ticket(ticket), callOptions);
    }

    public static void put(FlightClient client, HasPathId pathId, NewTable table, BufferAllocator allocator, CallOption ... callOptions) {
        FlightClientHelper.put(client, FlightClientHelper.descriptor(pathId), table, allocator, callOptions);
    }

    public static void put(FlightClient client, HasPathId pathId, FlightStream input, CallOption ... callOptions) {
        FlightClientHelper.put(client, FlightClientHelper.descriptor(pathId), input, callOptions);
    }

    public static void put(FlightClient client, FlightDescriptor descriptor, NewTable table, BufferAllocator allocator, CallOption ... callOptions) {
        VectorSchemaRoot root = VectorSchemaRootAdapter.of(table, allocator);
        FlightClient.ClientStreamListener out = client.startPut(descriptor, root, (FlightClient.PutListener)new AsyncPutListener(), callOptions);
        out.putNext();
        root.clear();
        out.completed();
        out.getResult();
    }

    public static void put(FlightClient client, FlightDescriptor descriptor, FlightStream input, CallOption ... callOptions) {
        FlightClient.ClientStreamListener out = client.startPut(descriptor, input.getRoot(), (FlightClient.PutListener)new AsyncPutListener(), callOptions);
        while (input.next()) {
            out.putNext();
            input.getRoot().clear();
        }
        out.completed();
        out.getResult();
    }

    public static SchemaResult getSchema(FlightClient client, HasPathId pathId, CallOption ... callOptions) {
        return client.getSchema(FlightClientHelper.descriptor(pathId), callOptions);
    }

    private static Ticket ticket(HasTicketId ticket) {
        return new Ticket(ticket.ticketId().bytes());
    }

    private static FlightDescriptor descriptor(HasPathId pathId) {
        return FlightDescriptor.path((Iterable)pathId.pathId().path());
    }
}

