/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.api.Pair;
import io.deephaven.api.Strings;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Partition;
import io.deephaven.client.impl.AggSpecBuilder;
import io.deephaven.proto.backplane.grpc.Aggregation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

class AggregationBuilder
implements Aggregation.Visitor {
    private List<Aggregation> out;

    AggregationBuilder() {
    }

    public static List<Aggregation> adapt(io.deephaven.api.agg.Aggregation agg) {
        return ((AggregationBuilder)agg.walk((Aggregation.Visitor)new AggregationBuilder())).out();
    }

    List<Aggregation> out() {
        return Objects.requireNonNull(this.out);
    }

    private static <T> Aggregation of(BiFunction<Aggregation.Builder, T, Aggregation.Builder> f, T obj) {
        return f.apply(Aggregation.newBuilder(), (Aggregation.Builder)obj).build();
    }

    public void visit(Aggregations aggregations) {
        this.out = aggregations.aggregations().stream().map(AggregationBuilder::adapt).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void visit(ColumnAggregation columnAgg) {
        this.out = Collections.singletonList(AggregationBuilder.of(Aggregation.Builder::setColumns, Aggregation.AggregationColumns.newBuilder().setSpec(AggSpecBuilder.adapt(columnAgg.spec())).addMatchPairs(Strings.of((Pair)columnAgg.pair()))));
    }

    public void visit(ColumnAggregations columnAggs) {
        Aggregation.AggregationColumns.Builder builder = Aggregation.AggregationColumns.newBuilder().setSpec(AggSpecBuilder.adapt(columnAggs.spec()));
        for (Pair pair : columnAggs.pairs()) {
            builder.addMatchPairs(Strings.of((Pair)pair));
        }
        this.out = Collections.singletonList(AggregationBuilder.of(Aggregation.Builder::setColumns, builder));
    }

    public void visit(Count count) {
        this.out = Collections.singletonList(AggregationBuilder.of(Aggregation.Builder::setCount, Aggregation.AggregationCount.newBuilder().setColumnName(count.column().name())));
    }

    public void visit(FirstRowKey firstRowKey) {
        this.out = Collections.singletonList(AggregationBuilder.of(Aggregation.Builder::setFirstRowKey, Aggregation.AggregationRowKey.newBuilder().setColumnName(firstRowKey.column().name())));
    }

    public void visit(LastRowKey lastRowKey) {
        this.out = Collections.singletonList(AggregationBuilder.of(Aggregation.Builder::setLastRowKey, Aggregation.AggregationRowKey.newBuilder().setColumnName(lastRowKey.column().name())));
    }

    public void visit(Partition partition) {
        this.out = Collections.singletonList(AggregationBuilder.of(Aggregation.Builder::setPartition, Aggregation.AggregationPartition.newBuilder().setColumnName(partition.column().name()).setIncludeGroupByColumns(partition.includeGroupByColumns())));
    }
}

