/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.AuthenticationCallCredentials;
import io.deephaven.client.impl.BearerHandler;
import io.deephaven.proto.DeephavenChannel;
import io.deephaven.proto.backplane.grpc.ConfigurationConstantsRequest;
import io.deephaven.proto.backplane.grpc.ConfigurationConstantsResponse;
import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Authentication {
    public static final Metadata.Key<String> AUTHORIZATION_HEADER = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final DeephavenChannel channel;
    private final String authenticationTypeAndValue;
    private final BearerHandler bearerHandler = new BearerHandler();
    private final CountDownLatch done = new CountDownLatch(1);
    private final CompletableFuture<Authentication> future = new CompletableFuture();
    private ClientCallStreamObserver<?> requestStream;
    private ConfigurationConstantsResponse response;
    private Throwable error;

    public static Authentication authenticate(DeephavenChannel channel, String authenticationTypeAndValue) {
        Authentication authentication = new Authentication(channel, authenticationTypeAndValue);
        authentication.start();
        return authentication;
    }

    private Authentication(DeephavenChannel channel, String authenticationTypeAndValue) {
        this.channel = Objects.requireNonNull(channel);
        this.authenticationTypeAndValue = Objects.requireNonNull(authenticationTypeAndValue);
    }

    public void await() throws InterruptedException {
        this.done.await();
    }

    public boolean await(Duration duration) throws InterruptedException {
        return this.done.await(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void awaitOrCancel() throws InterruptedException {
        try {
            this.done.await();
        }
        catch (InterruptedException e) {
            this.cancel("Thread interrupted", e);
            throw e;
        }
    }

    public boolean awaitOrCancel(Duration duration) throws InterruptedException {
        boolean finished;
        try {
            finished = this.done.await(duration.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            this.cancel("Thread interrupted", e);
            throw e;
        }
        if (!finished) {
            this.cancel("Timed out", null);
        }
        return finished;
    }

    public CompletableFuture<Authentication> future() {
        return this.future.whenComplete((r, t) -> {
            if (this.future.isCancelled()) {
                this.requestStream.cancel("User cancelled", null);
            }
        });
    }

    public void cancel(String message, Throwable cause) {
        this.requestStream.cancel(message, cause);
    }

    public Optional<DeephavenChannel> bearerChannel() {
        if (this.done.getCount() != 0L) {
            throw new IllegalStateException("Must await response");
        }
        if (this.response == null) {
            return Optional.empty();
        }
        return Optional.of(Authentication.credsAndInterceptor(this.channel, this.bearerHandler, this.bearerHandler));
    }

    public Optional<ConfigurationConstantsResponse> configurationConstants() {
        if (this.done.getCount() != 0L) {
            throw new IllegalStateException("Must await response");
        }
        return Optional.ofNullable(this.response);
    }

    public Optional<Throwable> error() {
        if (this.done.getCount() != 0L) {
            throw new IllegalStateException("Must await response");
        }
        return Optional.ofNullable(this.error);
    }

    public void throwOnError() {
        if (this.done.getCount() != 0L) {
            throw new IllegalStateException("Must await response");
        }
        if (this.error != null) {
            throw Authentication.toRuntimeException(this.error);
        }
    }

    BearerHandler bearerHandler() {
        return this.bearerHandler;
    }

    private void start() {
        DeephavenChannel initialChannel = Authentication.credsAndInterceptor(this.channel, new AuthenticationCallCredentials(this.authenticationTypeAndValue), this.bearerHandler);
        initialChannel.config().getConfigurationConstants(ConfigurationConstantsRequest.getDefaultInstance(), (StreamObserver)new Observer());
    }

    private static DeephavenChannel credsAndInterceptor(DeephavenChannel channel, CallCredentials callCredentials, ClientInterceptor clientInterceptor) {
        return DeephavenChannel.withClientInterceptors((DeephavenChannel)DeephavenChannel.withCallCredentials((DeephavenChannel)channel, (CallCredentials)callCredentials), (ClientInterceptor[])new ClientInterceptor[]{clientInterceptor});
    }

    private static RuntimeException toRuntimeException(Throwable t) {
        for (Throwable cause = Objects.requireNonNull(t); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException se = (StatusException)cause;
                return new StatusRuntimeException(se.getStatus(), se.getTrailers());
            }
            if (cause instanceof StatusRuntimeException) {
                StatusRuntimeException se = (StatusRuntimeException)cause;
                return new StatusRuntimeException(se.getStatus(), se.getTrailers());
            }
            if (!(cause instanceof RuntimeException)) continue;
            return (RuntimeException)cause;
        }
        return Status.UNKNOWN.withDescription("unexpected exception").withCause(t).asRuntimeException();
    }

    private class Observer
    implements ClientResponseObserver<ConfigurationConstantsRequest, ConfigurationConstantsResponse> {
        private Observer() {
        }

        public void beforeStart(ClientCallStreamObserver<ConfigurationConstantsRequest> stream) {
            Authentication.this.requestStream = stream;
        }

        public void onNext(ConfigurationConstantsResponse response) {
            Authentication.this.response = response;
        }

        public void onError(Throwable t) {
            Authentication.this.error = t;
            Authentication.this.done.countDown();
            Authentication.this.future.complete(Authentication.this);
        }

        public void onCompleted() {
            if (Authentication.this.response == null) {
                Authentication.this.error = new IllegalStateException("Completed without response");
            }
            Authentication.this.done.countDown();
            Authentication.this.future.complete(Authentication.this);
        }
    }
}

