/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.ClientConfig;
import io.deephaven.ssl.config.SSLConfig;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustJdk;
import io.deephaven.ssl.config.impl.KickstartUtils;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.Map;
import javax.net.ssl.SSLException;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.netty.util.NettySslUtils;

public final class ChannelHelper {
    public static final int DEFAULT_TLS_PORT = 443;
    public static final int DEFAULT_PLAINTEXT_PORT = 10000;

    public static ManagedChannel channel(ClientConfig clientConfig) {
        return ChannelHelper.channelBuilder(clientConfig).build();
    }

    public static ManagedChannelBuilder<?> channelBuilder(ClientConfig clientConfig) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)clientConfig.target().toString()).maxInboundMessageSize(clientConfig.maxInboundMessageSize());
        if (clientConfig.target().isSecure()) {
            SSLConfig ssl = clientConfig.ssl().orElseGet(SSLConfig::empty).orTrust((Trust)TrustJdk.of());
            SSLFactory sslFactory = KickstartUtils.create((SSLConfig)ssl);
            SslContextBuilder sslBuilder = NettySslUtils.forClient((SSLFactory)sslFactory);
            GrpcSslContexts.configure((SslContextBuilder)sslBuilder);
            if (ssl.protocols().isPresent() || ssl.ciphers().isPresent()) {
                sslBuilder.protocols((Iterable)sslFactory.getProtocols()).ciphers((Iterable)sslFactory.getCiphers(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
            }
            try {
                channelBuilder.sslContext(sslBuilder.build());
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        } else {
            channelBuilder.usePlaintext();
        }
        clientConfig.userAgent().ifPresent(arg_0 -> ((NettyChannelBuilder)channelBuilder).userAgent(arg_0));
        clientConfig.overrideAuthority().ifPresent(arg_0 -> ((NettyChannelBuilder)channelBuilder).overrideAuthority(arg_0));
        if (!clientConfig.extraHeaders().isEmpty()) {
            channelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)ChannelHelper.of(clientConfig.extraHeaders()))});
        }
        return channelBuilder;
    }

    private static Metadata of(Map<String, String> map) {
        Metadata metadata = new Metadata();
        map.forEach((k, v) -> metadata.put(Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), v));
        return metadata;
    }
}

