/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.auto.service.AutoService;
import io.deephaven.uri.DeephavenTarget;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.DnsNameResolverProvider;
import java.net.URI;

public final class DeephavenTargetNameResolverProviders {
    private static final DnsNameResolverProvider DNS_NAME_RESOLVER_PROVIDER = new DnsNameResolverProvider();

    private static URI deephavenToDnsTarget(URI targetUri) {
        DeephavenTarget deephavenTarget = DeephavenTarget.of((URI)targetUri);
        return deephavenTarget.port().isPresent() ? URI.create(String.format("dns:///%s:%d", deephavenTarget.host(), deephavenTarget.port().getAsInt())) : URI.create(String.format("dns:///%s", deephavenTarget.host()));
    }

    @AutoService(value={NameResolverProvider.class})
    public static final class Secure
    extends NameResolverProvider {
        private static NameResolver.Args setDefaultPort(NameResolver.Args args) {
            return args.toBuilder().setDefaultPort(443).build();
        }

        protected boolean isAvailable() {
            return true;
        }

        protected int priority() {
            return 5;
        }

        public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            if (!"dh".equals(targetUri.getScheme())) {
                return null;
            }
            return DNS_NAME_RESOLVER_PROVIDER.newNameResolver(DeephavenTargetNameResolverProviders.deephavenToDnsTarget(targetUri), Secure.setDefaultPort(args));
        }

        public String getDefaultScheme() {
            return "dh";
        }
    }

    @AutoService(value={NameResolverProvider.class})
    public static final class Plaintext
    extends NameResolverProvider {
        private static NameResolver.Args setDefaultPort(NameResolver.Args args) {
            return args.toBuilder().setDefaultPort(10000).build();
        }

        protected boolean isAvailable() {
            return true;
        }

        protected int priority() {
            return 5;
        }

        public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            if (!"dh+plain".equals(targetUri.getScheme())) {
                return null;
            }
            return DNS_NAME_RESOLVER_PROVIDER.newNameResolver(DeephavenTargetNameResolverProviders.deephavenToDnsTarget(targetUri), Plaintext.setDefaultPort(args));
        }

        public String getDefaultScheme() {
            return "dh+plain";
        }
    }
}

