/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.client.impl.ImmutableExportRequest;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.qst.table.TableSpec;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
@SimpleStyle
abstract class ExportRequest {
    ExportRequest() {
    }

    public static ExportRequest of(TableSpec table, Listener listener) {
        return ImmutableExportRequest.of(table, listener);
    }

    @Value.Parameter
    public abstract TableSpec table();

    @Value.Parameter
    public abstract Listener listener();

    private static class LoggingListener
    implements Listener {
        private static final Logger log = LoggerFactory.getLogger(LoggingListener.class);
        private final AtomicBoolean onErrorNotified;

        private LoggingListener() {
            this(new AtomicBoolean(false));
        }

        private LoggingListener(AtomicBoolean onErrorNotified) {
            this.onErrorNotified = Objects.requireNonNull(onErrorNotified);
        }

        @Override
        public void onNext(ExportedTableCreationResponse response) {
            if (response.getSuccess()) {
                String reference = ExportTicketHelper.toReadableString((TableReference)response.getResultId(), (String)"resultId");
                log.debug("ExportedTableCreationResponse for '{}' was successful", (Object)reference);
                return;
            }
            String reference = ExportTicketHelper.toReadableString((TableReference)response.getResultId(), (String)"resultId");
            log.warn("ExportedTableCreationResponse for '{}' was not successful: {}", (Object)reference, (Object)response.getErrorInfo());
        }

        @Override
        public void onError(Throwable t) {
            if (this.onErrorNotified.compareAndSet(false, true)) {
                log.error("LoggingListener onError", t);
            }
        }

        @Override
        public void onCompleted() {
            log.debug("LoggingListener onCompleted");
        }
    }

    static interface Listener {
        public static Listener logging() {
            return new LoggingListener();
        }

        public void onNext(ExportedTableCreationResponse var1);

        public void onError(Throwable var1);

        public void onCompleted();
    }
}

