/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.FieldInfo;
import io.deephaven.proto.backplane.grpc.FieldsChangeUpdate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class FieldChanges {
    private final FieldsChangeUpdate changes;

    FieldChanges(FieldsChangeUpdate changes) {
        this.changes = Objects.requireNonNull(changes);
    }

    public boolean isEmpty() {
        return this.changes.getCreatedCount() == 0 && this.changes.getUpdatedCount() == 0 && this.changes.getRemovedCount() == 0;
    }

    public List<FieldInfo> created() {
        return this.changes.getCreatedList().stream().map(FieldInfo::new).collect(Collectors.toList());
    }

    public List<FieldInfo> updated() {
        return this.changes.getUpdatedList().stream().map(FieldInfo::new).collect(Collectors.toList());
    }

    public List<FieldInfo> removed() {
        return this.changes.getRemovedList().stream().map(FieldInfo::new).collect(Collectors.toList());
    }

    public String toString() {
        return this.changes.toString();
    }
}

