/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.ExportId;
import io.deephaven.client.impl.PathId;
import io.deephaven.client.impl.ServerObject;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.TicketId;
import io.deephaven.client.impl.TypedTicket;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class ServerObjectBase
implements ServerObject {
    final Session session;
    final ExportId exportId;

    static void checkType(String expected, ExportId exportId) {
        String actual = exportId.type().orElse(null);
        if (!expected.equals(actual)) {
            throw new IllegalArgumentException(String.format("Invalid type. expected=%s, actual=%s", expected, actual));
        }
    }

    ServerObjectBase(Session session, ExportId exportId) {
        this.session = Objects.requireNonNull(session);
        this.exportId = Objects.requireNonNull(exportId);
    }

    @Override
    public final ExportId exportId() {
        return this.exportId;
    }

    @Override
    public final PathId pathId() {
        return this.exportId.pathId();
    }

    @Override
    public final TicketId ticketId() {
        return this.exportId.ticketId();
    }

    @Override
    public final TypedTicket typedTicket() {
        return this.exportId.typedTicket();
    }

    @Override
    public final CompletableFuture<Void> release() {
        return this.session.release(this.exportId);
    }

    @Override
    public final void close() {
        this.session.release(this.exportId);
    }

    public final String toString() {
        return this.exportId.toString();
    }
}

