/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.client.impl.ImmutableSessionImplConfig;
import io.deephaven.client.impl.SessionImpl;
import io.deephaven.proto.DeephavenChannel;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class SessionImplConfig {
    public static final String DEEPHAVEN_SESSION_BATCH = "deephaven.session.batch";
    public static final String DEEPHAVEN_SESSION_BATCH_STACKTRACES = "deephaven.session.batch.stacktraces";
    public static final String DEEPHAVEN_SESSION_EXECUTE_TIMEOUT = "deephaven.session.executeTimeout";
    public static final String DEEPHAVEN_SESSION_CLOSE_TIMEOUT = "deephaven.session.closeTimeout";

    public static Builder builder() {
        return ImmutableSessionImplConfig.builder();
    }

    public abstract ScheduledExecutorService executor();

    public abstract DeephavenChannel channel();

    @Value.Default
    public String authenticationTypeAndValue() {
        return "Anonymous";
    }

    @Value.Default
    public boolean delegateToBatch() {
        String property = System.getProperty(DEEPHAVEN_SESSION_BATCH);
        return property == null || Boolean.parseBoolean(property);
    }

    @Value.Default
    public boolean mixinStacktrace() {
        return Boolean.getBoolean(DEEPHAVEN_SESSION_BATCH_STACKTRACES);
    }

    @Value.Default
    public Duration executeTimeout() {
        return Duration.parse(System.getProperty(DEEPHAVEN_SESSION_EXECUTE_TIMEOUT, "PT1m"));
    }

    @Value.Default
    public Duration closeTimeout() {
        return Duration.parse(System.getProperty(DEEPHAVEN_SESSION_CLOSE_TIMEOUT, "PT5s"));
    }

    public final SessionImpl createSession() throws InterruptedException {
        return SessionImpl.create(this);
    }

    public static interface Builder {
        public Builder executor(ScheduledExecutorService var1);

        public Builder channel(DeephavenChannel var1);

        public Builder authenticationTypeAndValue(String var1);

        public Builder delegateToBatch(boolean var1);

        public Builder mixinStacktrace(boolean var1);

        public Builder executeTimeout(Duration var1);

        public Builder closeTimeout(Duration var1);

        public SessionImplConfig build();
    }
}

