/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.FutureHelper;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.client.impl.TableHandleManager;
import io.deephaven.qst.table.TableSpec;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;

public interface TableService
extends TableHandleManager {
    public TableHandleManager batch();

    public TableHandleManager batch(boolean var1);

    public TableHandleManager serial();

    public TableHandleFuture executeAsync(TableSpec var1);

    public List<? extends TableHandleFuture> executeAsync(Iterable<? extends TableSpec> var1);

    public static interface TableHandleFuture
    extends Future<TableHandle> {
        default public TableHandle getOrCancel() throws InterruptedException, ExecutionException {
            return FutureHelper.getOrCancel(this);
        }

        default public TableHandle getOrCancel(Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
            return FutureHelper.getOrCancel(this, timeout);
        }

        public static void cancelOrClose(Iterable<? extends TableHandleFuture> futures, boolean mayInterruptIfRunning) {
            FutureHelper.cancelOrConsume(futures, (tableHandle, e, c) -> {
                if (tableHandle != null) {
                    tableHandle.close();
                }
            }, mayInterruptIfRunning);
        }
    }
}

