/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.Export;
import io.deephaven.client.impl.ExportService;
import io.deephaven.client.impl.ExportServiceRequest;
import io.deephaven.client.impl.ExportsRequest;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.qst.table.TableSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class TableServiceImpl {
    TableServiceImpl() {
    }

    static TableHandle execute(ExportService exportService, TableSpec table, Lifecycle lifecycle) throws InterruptedException, TableHandle.TableHandleException {
        return TableServiceImpl.execute(exportService, Collections.singletonList(table), lifecycle).get(0);
    }

    static List<TableHandle> execute(ExportService exportService, Iterable<TableSpec> tables, Lifecycle lifecycle) throws InterruptedException, TableHandle.TableHandleException {
        List<TableHandle> handles = TableServiceImpl.executeImpl(exportService, tables, lifecycle);
        for (TableHandle handle : handles) {
            handle.await();
            handle.throwOnError();
        }
        return handles;
    }

    static TableHandle executeUnchecked(ExportService exportService, TableSpec table, Lifecycle lifecycle) {
        TableHandle handle = new TableHandle(table, lifecycle);
        try (ExportServiceRequest request = exportService.exportRequest(ExportsRequest.of(handle.exportRequest()));){
            List<Export> exports = request.exports();
            if (exports.size() != 1) {
                throw new IllegalStateException();
            }
            handle.init(exports.get(0));
            request.send();
        }
        handle.awaitUnchecked();
        handle.throwOnErrorUnchecked();
        return handle;
    }

    private static List<TableHandle> executeImpl(ExportService exportService, Iterable<TableSpec> specs, Lifecycle lifecycle) {
        ExportsRequest.Builder exportBuilder = ExportsRequest.builder();
        ArrayList<TableHandle> handles = new ArrayList<TableHandle>();
        for (TableSpec spec : specs) {
            TableHandle handle = new TableHandle(spec, lifecycle);
            handles.add(handle);
            exportBuilder.addRequests(handle.exportRequest());
        }
        try (ExportServiceRequest request = exportService.exportRequest(exportBuilder.build());){
            List<Export> exports = request.exports();
            if (exports.size() != handles.size()) {
                throw new IllegalStateException();
            }
            int L = exports.size();
            for (int i = 0; i < L; ++i) {
                ((TableHandle)handles.get(i)).init(exports.get(i));
            }
            request.send();
        }
        return handles;
    }

    static interface Lifecycle {
        public void onInit(TableHandle var1);

        public void onRelease(TableHandle var1);
    }
}

