/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl.script;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.FieldChanges;
import io.deephaven.client.impl.script.Changes;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Changes", generator="Immutables")
@Immutable
final class ImmutableChanges
extends Changes {
    @Nullable
    private final String errorMessage;
    private final FieldChanges changes;

    private ImmutableChanges(Builder builder) {
        this.errorMessage = builder.errorMessage;
        this.changes = builder.changes;
    }

    @Override
    public Optional<String> errorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    @Override
    public FieldChanges changes() {
        return this.changes;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChanges && this.equalTo(0, (ImmutableChanges)another);
    }

    private boolean equalTo(int synthetic, ImmutableChanges another) {
        return Objects.equals(this.errorMessage, another.errorMessage) && this.changes.equals(another.changes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + this.changes.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Changes{");
        if (this.errorMessage != null) {
            builder.append("errorMessage=").append(this.errorMessage);
        }
        if (builder.length() > 8) {
            builder.append(", ");
        }
        builder.append("changes=").append(this.changes);
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Changes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Changes.Builder {
        private static final long INIT_BIT_CHANGES = 1L;
        private static final long OPT_BIT_ERROR_MESSAGE = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String errorMessage;
        @Nullable
        private FieldChanges changes;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder errorMessage(String errorMessage) {
            Builder.checkNotIsSet(this.errorMessageIsSet(), "errorMessage");
            this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessage(Optional<String> errorMessage) {
            Builder.checkNotIsSet(this.errorMessageIsSet(), "errorMessage");
            this.errorMessage = errorMessage.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder changes(FieldChanges changes) {
            Builder.checkNotIsSet(this.changesIsSet(), "changes");
            this.changes = Objects.requireNonNull(changes, "changes");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableChanges build() {
            this.checkRequiredAttributes();
            return new ImmutableChanges(this);
        }

        private boolean errorMessageIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean changesIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Changes is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.changesIsSet()) {
                attributes.add("changes");
            }
            return "Cannot build Changes, some of required attributes are not set " + attributes;
        }
    }
}

