/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.common.annotations.VisibleForTesting;
import io.deephaven.client.impl.Authentication;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;

public final class BearerHandler
extends CallCredentials
implements ClientInterceptor {
    public static final String BEARER_PREFIX = "Bearer ";
    private volatile String bearerToken;

    private static Optional<String> parseBearerToken(Metadata metadata) {
        Iterable authenticationValues = metadata.getAll(Authentication.AUTHORIZATION_HEADER);
        if (authenticationValues == null) {
            return Optional.empty();
        }
        String lastBearerValue = null;
        for (String authenticationValue : authenticationValues) {
            if (!authenticationValue.startsWith(BEARER_PREFIX)) continue;
            lastBearerValue = authenticationValue;
        }
        if (lastBearerValue == null) {
            return Optional.empty();
        }
        return Optional.of(lastBearerValue.substring(BEARER_PREFIX.length()));
    }

    public void setBearerToken(String bearerToken) {
        String localBearerToken = this.bearerToken;
        if (!Objects.equals(localBearerToken, bearerToken)) {
            this.bearerToken = Objects.requireNonNull(bearerToken);
        }
    }

    @VisibleForTesting
    public UUID getCurrentToken() {
        return UUID.fromString(this.bearerToken);
    }

    private void handleMetadata(Metadata metadata) {
        BearerHandler.parseBearerToken(metadata).ifPresent(this::setBearerToken);
    }

    String authenticationValue() {
        return BEARER_PREFIX + this.bearerToken;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        String bearerToken = this.bearerToken;
        if (bearerToken == null) {
            applier.fail(Status.UNAUTHENTICATED);
            return;
        }
        Metadata headers = new Metadata();
        headers.put(Authentication.AUTHORIZATION_HEADER, (Object)this.authenticationValue());
        applier.apply(headers);
    }

    public void thisUsesUnstableApi() {
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new BearerCall(next.newCall(method, callOptions));
    }

    private final class BearerListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        public BearerListener(ClientCall.Listener<RespT> delegate) {
            super(delegate);
        }

        public void onHeaders(Metadata headers) {
            try {
                BearerHandler.this.handleMetadata(headers);
            }
            finally {
                super.onHeaders(headers);
            }
        }

        public void onClose(Status status, Metadata trailers) {
            try {
                BearerHandler.this.handleMetadata(trailers);
            }
            finally {
                super.onClose(status, trailers);
            }
        }
    }

    private final class BearerCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        public BearerCall(ClientCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            super.start(new BearerListener<RespT>(responseListener), headers);
        }
    }
}

