/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.ClientData;
import io.deephaven.client.impl.ExportId;
import io.deephaven.client.impl.ObjectService;
import io.deephaven.client.impl.ServerData;
import io.deephaven.client.impl.ServerObjectBase;
import io.deephaven.client.impl.Session;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class CustomObject
extends ServerObjectBase
implements ObjectService.Fetchable,
ObjectService.Bidirectional {
    private static final Set<String> KNOWN_TYPES = Collections.singleton("Table");

    CustomObject(Session session, ExportId exportId) {
        super(session, exportId);
        if (!exportId.type().isPresent()) {
            throw new IllegalArgumentException("Expected type to be present, is not");
        }
        String type = exportId.type().get();
        if (KNOWN_TYPES.contains(type)) {
            throw new IllegalArgumentException(String.format("Can't construct a CustomObject with a well-known type '%s'", type));
        }
    }

    @Override
    public String type() {
        return this.exportId().type().orElseThrow(IllegalStateException::new);
    }

    @Override
    public CompletableFuture<ServerData> fetch() {
        return this.session.fetch(this);
    }

    @Override
    public ObjectService.MessageStream<ClientData> connect(ObjectService.MessageStream<ServerData> receiveStream) {
        return this.session.connect(this, receiveStream);
    }
}

