/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.ExportId;
import io.deephaven.client.impl.ExportRequest;
import io.deephaven.client.impl.ExportStates;
import io.deephaven.client.impl.HasExportId;
import io.deephaven.client.impl.PathId;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.TicketId;
import io.deephaven.client.impl.TypedTicket;
import io.deephaven.qst.table.TableSpec;
import java.util.Objects;

public final class Export
implements AutoCloseable,
HasExportId {
    private final ExportStates.State state;
    private final ExportRequest.Listener listener;
    private boolean released;

    Export(ExportStates.State state, ExportRequest.Listener listener) {
        this.state = Objects.requireNonNull(state);
        this.listener = Objects.requireNonNull(listener);
        this.released = false;
    }

    @Override
    public ExportId exportId() {
        return new ExportId("Table", this.state.exportId());
    }

    @Override
    public TypedTicket typedTicket() {
        return this.exportId().typedTicket();
    }

    @Override
    public PathId pathId() {
        return this.exportId().pathId();
    }

    @Override
    public TicketId ticketId() {
        return this.exportId().ticketId();
    }

    public Session session() {
        return this.state.session();
    }

    ExportStates exportStates() {
        return this.state.exportStates();
    }

    ExportStates.State state() {
        return this.state;
    }

    public TableSpec table() {
        return this.state.table();
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    public synchronized Export newReference(ExportRequest.Listener listener) {
        if (this.released) {
            throw new IllegalStateException("Should not take newRef after release");
        }
        return this.state.newReference(listener);
    }

    public synchronized boolean release() {
        if (this.released) {
            return false;
        }
        this.state.release(this);
        this.released = true;
        return true;
    }

    ExportRequest.Listener listener() {
        return this.listener;
    }

    @Override
    public void close() {
        this.release();
    }

    public String toString() {
        return "Export{id=" + this.exportId().id() + '}';
    }

    public String toReadableString() {
        return this.exportId().toString();
    }
}

