/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.CustomObject;
import io.deephaven.client.impl.HasExportId;
import io.deephaven.client.impl.PathId;
import io.deephaven.client.impl.ServerObject;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.TableObject;
import io.deephaven.client.impl.TicketId;
import io.deephaven.client.impl.TypedTicket;
import io.deephaven.client.impl.UnknownObject;
import io.deephaven.proto.util.ExportTicketHelper;
import java.util.Optional;

public final class ExportId
implements HasExportId {
    private final String type;
    private final int exportId;

    ExportId(String type, int exportId) {
        if (type != null && type.isEmpty()) {
            throw new IllegalArgumentException("Must use null instead of empty string to represent no type");
        }
        this.type = type;
        this.exportId = exportId;
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public ExportId exportId() {
        return this;
    }

    @Override
    public TicketId ticketId() {
        return new TicketId(this.ticket());
    }

    @Override
    public TypedTicket typedTicket() {
        return new TypedTicket(this.type, this);
    }

    @Override
    public PathId pathId() {
        return new PathId(ExportTicketHelper.exportIdToPath((int)this.exportId));
    }

    public String toString() {
        return (this.type == null ? "?:" : this.type + ":") + ExportTicketHelper.toReadableString((int)this.exportId);
    }

    int id() {
        return this.exportId;
    }

    byte[] ticket() {
        return ExportTicketHelper.exportIdToBytes((int)this.exportId);
    }

    ServerObject toServerObject(Session session) {
        if (this.type == null) {
            return new UnknownObject(session, this);
        }
        switch (this.type) {
            case "Table": {
                return new TableObject(session, this);
            }
        }
        return new CustomObject(session, this);
    }
}

