/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.common.annotations.VisibleForTesting;
import io.deephaven.client.impl.BatchTableRequestBuilder;
import io.deephaven.client.impl.Export;
import io.deephaven.client.impl.ExportRequest;
import io.deephaven.client.impl.ExportService;
import io.deephaven.client.impl.ExportServiceRequest;
import io.deephaven.client.impl.ExportTicketCreator;
import io.deephaven.client.impl.ExportsRequest;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.SessionImpl;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.backplane.grpc.ReleaseRequest;
import io.deephaven.proto.backplane.grpc.ReleaseResponse;
import io.deephaven.proto.backplane.grpc.SessionServiceGrpc;
import io.deephaven.proto.backplane.grpc.TableServiceGrpc;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.qst.table.ParentsVisitor;
import io.deephaven.qst.table.TableSpec;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExportStates
implements ExportService {
    private final SessionImpl session;
    private final SessionServiceGrpc.SessionServiceStub sessionStub;
    private final TableServiceGrpc.TableServiceStub tableStub;
    private final Map<TableSpec, State> exports;
    private final ExportTicketCreator exportTicketCreator;
    private final Lock lock;

    ExportStates(SessionImpl session, SessionServiceGrpc.SessionServiceStub sessionStub, TableServiceGrpc.TableServiceStub tableStub, ExportTicketCreator exportTicketCreator) {
        this.session = Objects.requireNonNull(session);
        this.sessionStub = Objects.requireNonNull(sessionStub);
        this.tableStub = Objects.requireNonNull(tableStub);
        this.exportTicketCreator = Objects.requireNonNull(exportTicketCreator);
        this.exports = new HashMap<TableSpec, State>();
        this.lock = new ReentrantLock();
    }

    @VisibleForTesting
    ExportStates(SessionServiceGrpc.SessionServiceStub sessionStub, TableServiceGrpc.TableServiceStub tableStub, ExportTicketCreator exportTicketCreator) {
        this.session = null;
        this.sessionStub = Objects.requireNonNull(sessionStub);
        this.tableStub = Objects.requireNonNull(tableStub);
        this.exportTicketCreator = Objects.requireNonNull(exportTicketCreator);
        this.exports = new HashMap<TableSpec, State>();
        this.lock = new ReentrantLock();
    }

    private Set<TableSpec> unreferenceableTables() {
        Set unreferenceableTables = ParentsVisitor.reachable(this.exports.keySet());
        unreferenceableTables.removeAll(this.exports.keySet());
        return unreferenceableTables;
    }

    private Optional<TableSpec> searchUnreferenceableTable(ExportsRequest request) {
        Set<TableSpec> unreferenceableTables = this.unreferenceableTables();
        Set<TableSpec> keySet = this.exports.keySet();
        return ParentsVisitor.search(request.tables(), keySet::contains, unreferenceableTables::contains);
    }

    @Override
    public ExportServiceRequest exportRequest(ExportsRequest requests) {
        this.lock.lock();
        try {
            return this.exportRequestImpl(requests);
        }
        catch (Throwable t) {
            this.lock.unlock();
            throw t;
        }
    }

    private ExportServiceRequest exportRequestImpl(ExportsRequest requests) {
        Runnable send;
        this.ensureNoUnreferenceableTables(requests);
        HashSet<TableSpec> oldExports = new HashSet<TableSpec>(this.exports.keySet());
        final ArrayList<Export> results = new ArrayList<Export>(requests.size());
        HashSet<TableSpec> newSpecs = new HashSet<TableSpec>(requests.size());
        final LinkedHashMap<Integer, State> newStates = new LinkedHashMap<Integer, State>(requests.size());
        for (ExportRequest request : requests) {
            Optional<State> existing = this.lookup(request.table());
            if (existing.isPresent()) {
                State existingState = existing.get();
                Export newReference = existingState.newReference(request.listener());
                results.add(newReference);
                continue;
            }
            int exportId = this.exportTicketCreator.createExportId();
            State state = new State(request.table(), exportId);
            if (this.exports.putIfAbsent(request.table(), state) != null) {
                throw new IllegalStateException("Unable to put export, already exists");
            }
            Export newExport = state.newReference(request.listener());
            newSpecs.add(request.table());
            newStates.put(exportId, state);
            results.add(newExport);
        }
        if (!newSpecs.isEmpty()) {
            List<TableSpec> postOrder = ExportStates.postOrderNewDependencies(oldExports, newSpecs);
            if (postOrder.isEmpty()) {
                throw new IllegalStateException();
            }
            BatchTableRequest request = BatchTableRequestBuilder.buildNoChecks(this::lookupTicket, postOrder);
            if (request.getOpsCount() == 0) {
                throw new IllegalStateException();
            }
            BatchHandler batchHandler = new BatchHandler(newStates);
            send = () -> this.tableStub.batch(request, (StreamObserver)batchHandler);
        } else {
            send = () -> {};
        }
        return new ExportServiceRequest(){
            boolean sent;
            boolean closed;

            @Override
            public List<Export> exports() {
                return results;
            }

            @Override
            public void send() {
                if (this.closed || this.sent) {
                    return;
                }
                this.sent = true;
                send.run();
            }

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    if (!this.sent) {
                        this.cleanupUnsent();
                    }
                }
                finally {
                    ExportStates.this.lock.unlock();
                }
            }

            private void cleanupUnsent() {
                for (Export result : results) {
                    State state = result.state();
                    if (newStates.containsKey(state.exportId())) {
                        ExportStates.this.removeImpl(state);
                        continue;
                    }
                    result.release();
                }
            }
        };
    }

    private void remove(State state) {
        this.lock.lock();
        try {
            this.removeImpl(state);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeImpl(State state) {
        if (!this.exports.remove(state.table(), state)) {
            throw new IllegalStateException("Unable to remove state");
        }
    }

    private Optional<State> lookup(TableSpec table) {
        return Optional.ofNullable(this.exports.get(table));
    }

    private OptionalInt lookupTicket(TableSpec table) {
        Optional<State> state = this.lookup(table);
        return state.isPresent() ? OptionalInt.of(state.get().exportId()) : OptionalInt.empty();
    }

    private static List<TableSpec> postOrderNewDependencies(Set<TableSpec> oldExports, Set<TableSpec> newExports) {
        Set reachableOld = ParentsVisitor.reachable(oldExports);
        List postOrderNew = ParentsVisitor.postOrderList(newExports);
        ArrayList<TableSpec> postOrderNewExcludeOld = new ArrayList<TableSpec>(postOrderNew.size());
        for (TableSpec table : postOrderNew) {
            if (reachableOld.contains(table)) continue;
            postOrderNewExcludeOld.add(table);
        }
        return postOrderNewExcludeOld;
    }

    private void ensureNoUnreferenceableTables(ExportsRequest requests) {
        Optional<TableSpec> unreferenceable = this.searchUnreferenceableTable(requests);
        if (unreferenceable.isPresent()) {
            throw new IllegalArgumentException(String.format("Unable to complete request, contains an unreferenceable table: %s. This is an indication that the query is trying to export a strict sub-DAG of the existing exports; this is problematic because there isn't (currently) a way to construct a query that guarantees the returned export would refer to the same physical table that the existing exports are based on. See https://github.com/deephaven/deephaven-core/issues/4733 for future improvements in this regard.", unreferenceable.get()));
        }
    }

    private static final class BatchHandler
    implements StreamObserver<ExportedTableCreationResponse> {
        private static final Logger log = LoggerFactory.getLogger(BatchHandler.class);
        private final Map<Integer, State> newStates;
        private final Set<State> handled;

        private BatchHandler(Map<Integer, State> newStates) {
            this.newStates = Objects.requireNonNull(newStates);
            this.handled = new HashSet<State>(newStates.size());
        }

        public void onNext(ExportedTableCreationResponse value) {
            if (!value.getResultId().hasTicket()) {
                return;
            }
            if (Ticket.getDefaultInstance().equals((Object)value.getResultId().getTicket())) {
                throw new IllegalStateException("Not expecting export creation responses for empty tickets");
            }
            int exportId = ExportTicketHelper.ticketToExportId((Ticket)value.getResultId().getTicket(), (String)"export");
            State state = this.newStates.get(exportId);
            if (state == null) {
                throw new IllegalStateException("Unable to find state for creation response");
            }
            if (!this.handled.add(state)) {
                throw new IllegalStateException(String.format("Server misbehaving, already received response for export id %d", exportId));
            }
            try {
                state.onCreationResponse(value);
            }
            catch (RuntimeException e) {
                log.error("state.onCreationResponse had unexpected exception", (Throwable)e);
                state.onCreationError(e);
            }
        }

        public void onError(Throwable t) {
            for (State state : this.newStates.values()) {
                try {
                    state.onCreationError(t);
                }
                catch (RuntimeException e) {
                    log.error("state.onCreationError had unexpected exception, ignoring", (Throwable)e);
                }
            }
        }

        public void onCompleted() {
            for (State state : this.newStates.values()) {
                try {
                    state.onCreationCompleted();
                }
                catch (RuntimeException e) {
                    log.error("state.onCreationCompleted had unexpected exception, ignoring", (Throwable)e);
                }
            }
        }
    }

    private static final class TicketReleaseHandler
    implements StreamObserver<ReleaseResponse> {
        private static final Logger log = LoggerFactory.getLogger(TicketReleaseHandler.class);
        private final int exportId;

        private TicketReleaseHandler(int exportId) {
            this.exportId = exportId;
        }

        public void onNext(ReleaseResponse value) {
        }

        public void onError(Throwable t) {
            log.error(String.format("onError releasing export id %d%n", this.exportId), t);
        }

        public void onCompleted() {
        }
    }

    class State {
        private final TableSpec table;
        private final int exportId;
        private final Set<Export> children;
        private ExportedTableCreationResponse creationResponse;
        private Throwable creationThrowable;
        private boolean creationCompleted;
        private boolean released;

        State(TableSpec table, int exportId) {
            this.table = Objects.requireNonNull(table);
            this.exportId = exportId;
            this.children = new LinkedHashSet<Export>();
        }

        Session session() {
            return ExportStates.this.session;
        }

        TableSpec table() {
            return this.table;
        }

        int exportId() {
            return this.exportId;
        }

        ExportStates exportStates() {
            return ExportStates.this;
        }

        synchronized Export newReference(ExportRequest.Listener listener) {
            if (this.released) {
                throw new IllegalStateException("Should not be creating new references from state after the state has been released");
            }
            Export export = new Export(this, listener);
            this.addChild(export);
            return export;
        }

        synchronized void release(Export export) {
            if (!this.children.remove(export)) {
                throw new IllegalStateException("Unable to remove child");
            }
            if (this.children.isEmpty()) {
                ExportStates.this.remove(this);
                this.released = true;
                ExportStates.this.sessionStub.release(ReleaseRequest.newBuilder().setId(ExportTicketHelper.wrapExportIdInTicket((int)this.exportId)).build(), (StreamObserver)new TicketReleaseHandler(this.exportId));
            }
        }

        synchronized void onCreationResponse(ExportedTableCreationResponse creationResponse) {
            if (this.creationResponse != null) {
                throw new IllegalStateException("Only expected at most one creation response");
            }
            this.creationResponse = Objects.requireNonNull(creationResponse);
            for (Export child : this.children) {
                child.listener().onNext(creationResponse);
            }
        }

        synchronized void onCreationError(Throwable t) {
            if (this.creationThrowable != null) {
                throw new IllegalStateException("Only expected at most one creation throwable");
            }
            this.creationThrowable = Objects.requireNonNull(t);
            for (Export child : this.children) {
                child.listener().onError(t);
            }
        }

        synchronized void onCreationCompleted() {
            if (this.creationCompleted) {
                throw new IllegalStateException("Only expected at most one creation completed");
            }
            this.creationCompleted = true;
            for (Export child : this.children) {
                child.listener().onCompleted();
            }
        }

        private void addChild(Export export) {
            if (!this.children.add(export)) {
                throw new IllegalStateException("Unable to add child");
            }
            if (this.creationResponse != null) {
                export.listener().onNext(this.creationResponse);
            }
            if (this.creationThrowable != null) {
                export.listener().onError(this.creationThrowable);
            }
            if (this.creationCompleted) {
                export.listener().onCompleted();
            }
        }
    }
}

