/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.client.impl.ExportRequest;
import io.deephaven.client.impl.ImmutableExportsRequest;
import io.deephaven.qst.table.TableSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
abstract class ExportsRequest
implements Iterable<ExportRequest> {
    ExportsRequest() {
    }

    public static Builder builder() {
        return ImmutableExportsRequest.builder();
    }

    public static ExportsRequest of(ExportRequest ... requests) {
        return ExportsRequest.builder().addRequests(requests).build();
    }

    public static ExportsRequest of(Collection<ExportRequest> requests) {
        return ExportsRequest.builder().addAllRequests(requests).build();
    }

    public static ExportsRequest logging(TableSpec ... tables) {
        return ExportsRequest.logging(Arrays.asList(tables));
    }

    public static ExportsRequest logging(Iterable<TableSpec> tables) {
        ExportRequest.Listener listener = ExportRequest.Listener.logging();
        Builder builder = ExportsRequest.builder();
        for (TableSpec table : tables) {
            builder.addRequests(ExportRequest.of(table, listener));
        }
        return builder.build();
    }

    abstract List<ExportRequest> requests();

    public final Iterable<TableSpec> tables() {
        return () -> this.requests().stream().map(ExportRequest::table).iterator();
    }

    public final int size() {
        return this.requests().size();
    }

    @Override
    public final Iterator<ExportRequest> iterator() {
        return this.requests().iterator();
    }

    @Override
    public final void forEach(Consumer<? super ExportRequest> action) {
        this.requests().forEach(action);
    }

    @Override
    public final Spliterator<ExportRequest> spliterator() {
        return this.requests().spliterator();
    }

    static interface Builder {
        public Builder addRequests(ExportRequest var1);

        public Builder addRequests(ExportRequest ... var1);

        public Builder addAllRequests(Iterable<? extends ExportRequest> var1);

        public ExportsRequest build();
    }
}

