/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.ClientConfig;
import io.deephaven.ssl.config.SSLConfig;
import io.deephaven.uri.DeephavenTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientConfig", generator="Immutables")
@Immutable
final class ImmutableClientConfig
extends ClientConfig {
    private final DeephavenTarget target;
    @Nullable
    private final SSLConfig ssl;
    @Nullable
    private final String userAgent;
    @Nullable
    private final String overrideAuthority;
    private final Map<String, String> extraHeaders;
    private final int maxInboundMessageSize;

    private ImmutableClientConfig(Builder builder) {
        this.target = builder.target;
        this.ssl = builder.ssl;
        this.userAgent = builder.userAgent;
        this.overrideAuthority = builder.overrideAuthority;
        this.extraHeaders = ImmutableClientConfig.createUnmodifiableMap(false, false, builder.extraHeaders);
        this.maxInboundMessageSize = builder.maxInboundMessageSizeIsSet() ? builder.maxInboundMessageSize : super.maxInboundMessageSize();
    }

    private ImmutableClientConfig(DeephavenTarget target, @Nullable SSLConfig ssl, @Nullable String userAgent, @Nullable String overrideAuthority, Map<String, String> extraHeaders, int maxInboundMessageSize) {
        this.target = target;
        this.ssl = ssl;
        this.userAgent = userAgent;
        this.overrideAuthority = overrideAuthority;
        this.extraHeaders = extraHeaders;
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @Override
    public DeephavenTarget target() {
        return this.target;
    }

    @Override
    public Optional<SSLConfig> ssl() {
        return Optional.ofNullable(this.ssl);
    }

    @Override
    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    @Override
    public Optional<String> overrideAuthority() {
        return Optional.ofNullable(this.overrideAuthority);
    }

    @Override
    public Map<String, String> extraHeaders() {
        return this.extraHeaders;
    }

    @Override
    public int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public final ImmutableClientConfig withTarget(DeephavenTarget value) {
        if (this.target == value) {
            return this;
        }
        DeephavenTarget newValue = Objects.requireNonNull(value, "target");
        return new ImmutableClientConfig(newValue, this.ssl, this.userAgent, this.overrideAuthority, this.extraHeaders, this.maxInboundMessageSize);
    }

    @Override
    public final ImmutableClientConfig withSsl(SSLConfig value) {
        SSLConfig newValue = Objects.requireNonNull(value, "ssl");
        if (this.ssl == newValue) {
            return this;
        }
        return new ImmutableClientConfig(this.target, newValue, this.userAgent, this.overrideAuthority, this.extraHeaders, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withSsl(Optional<? extends SSLConfig> optional) {
        SSLConfig value = optional.orElse(null);
        if (this.ssl == value) {
            return this;
        }
        return new ImmutableClientConfig(this.target, value, this.userAgent, this.overrideAuthority, this.extraHeaders, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withUserAgent(String value) {
        String newValue = Objects.requireNonNull(value, "userAgent");
        if (Objects.equals(this.userAgent, newValue)) {
            return this;
        }
        return new ImmutableClientConfig(this.target, this.ssl, newValue, this.overrideAuthority, this.extraHeaders, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withUserAgent(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userAgent, value)) {
            return this;
        }
        return new ImmutableClientConfig(this.target, this.ssl, value, this.overrideAuthority, this.extraHeaders, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withOverrideAuthority(String value) {
        String newValue = Objects.requireNonNull(value, "overrideAuthority");
        if (Objects.equals(this.overrideAuthority, newValue)) {
            return this;
        }
        return new ImmutableClientConfig(this.target, this.ssl, this.userAgent, newValue, this.extraHeaders, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withOverrideAuthority(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.overrideAuthority, value)) {
            return this;
        }
        return new ImmutableClientConfig(this.target, this.ssl, this.userAgent, value, this.extraHeaders, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withExtraHeaders(Map<String, ? extends String> entries) {
        if (this.extraHeaders == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableClientConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableClientConfig(this.target, this.ssl, this.userAgent, this.overrideAuthority, newValue, this.maxInboundMessageSize);
    }

    public final ImmutableClientConfig withMaxInboundMessageSize(int value) {
        if (this.maxInboundMessageSize == value) {
            return this;
        }
        return new ImmutableClientConfig(this.target, this.ssl, this.userAgent, this.overrideAuthority, this.extraHeaders, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientConfig && this.equalTo(0, (ImmutableClientConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableClientConfig another) {
        return this.target.equals(another.target) && Objects.equals(this.ssl, another.ssl) && Objects.equals(this.userAgent, another.userAgent) && Objects.equals(this.overrideAuthority, another.overrideAuthority) && this.extraHeaders.equals(another.extraHeaders) && this.maxInboundMessageSize == another.maxInboundMessageSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + Objects.hashCode(this.ssl);
        h += (h << 5) + Objects.hashCode(this.userAgent);
        h += (h << 5) + Objects.hashCode(this.overrideAuthority);
        h += (h << 5) + this.extraHeaders.hashCode();
        h += (h << 5) + this.maxInboundMessageSize;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ClientConfig{");
        builder.append("target=").append(this.target);
        if (this.ssl != null) {
            builder.append(", ");
            builder.append("ssl=").append(this.ssl);
        }
        if (this.userAgent != null) {
            builder.append(", ");
            builder.append("userAgent=").append(this.userAgent);
        }
        if (this.overrideAuthority != null) {
            builder.append(", ");
            builder.append("overrideAuthority=").append(this.overrideAuthority);
        }
        builder.append(", ");
        builder.append("extraHeaders=").append(this.extraHeaders);
        builder.append(", ");
        builder.append("maxInboundMessageSize=").append(this.maxInboundMessageSize);
        return builder.append("}").toString();
    }

    public static ImmutableClientConfig copyOf(ClientConfig instance) {
        if (instance instanceof ImmutableClientConfig) {
            return (ImmutableClientConfig)instance;
        }
        return ((Builder)ImmutableClientConfig.builder().target(instance.target()).ssl(instance.ssl()).userAgent(instance.userAgent()).overrideAuthority(instance.overrideAuthority()).putAllExtraHeaders(instance.extraHeaders())).maxInboundMessageSize(instance.maxInboundMessageSize()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ClientConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ClientConfig.Builder {
        private static final long INIT_BIT_TARGET = 1L;
        private static final long OPT_BIT_SSL = 1L;
        private static final long OPT_BIT_USER_AGENT = 2L;
        private static final long OPT_BIT_OVERRIDE_AUTHORITY = 4L;
        private static final long OPT_BIT_MAX_INBOUND_MESSAGE_SIZE = 8L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private DeephavenTarget target;
        @Nullable
        private SSLConfig ssl;
        @Nullable
        private String userAgent;
        @Nullable
        private String overrideAuthority;
        private final Map<String, String> extraHeaders = new LinkedHashMap<String, String>();
        private int maxInboundMessageSize;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder target(DeephavenTarget target) {
            Builder.checkNotIsSet(this.targetIsSet(), "target");
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder ssl(SSLConfig ssl) {
            Builder.checkNotIsSet(this.sslIsSet(), "ssl");
            this.ssl = Objects.requireNonNull(ssl, "ssl");
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ssl(Optional<? extends SSLConfig> ssl) {
            Builder.checkNotIsSet(this.sslIsSet(), "ssl");
            this.ssl = ssl.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder userAgent(String userAgent) {
            Builder.checkNotIsSet(this.userAgentIsSet(), "userAgent");
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userAgent(Optional<String> userAgent) {
            Builder.checkNotIsSet(this.userAgentIsSet(), "userAgent");
            this.userAgent = userAgent.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder overrideAuthority(String overrideAuthority) {
            Builder.checkNotIsSet(this.overrideAuthorityIsSet(), "overrideAuthority");
            this.overrideAuthority = Objects.requireNonNull(overrideAuthority, "overrideAuthority");
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder overrideAuthority(Optional<String> overrideAuthority) {
            Builder.checkNotIsSet(this.overrideAuthorityIsSet(), "overrideAuthority");
            this.overrideAuthority = overrideAuthority.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putExtraHeaders(String key, String value) {
            this.extraHeaders.put(Objects.requireNonNull(key, "extraHeaders key"), value == null ? Objects.requireNonNull(value, "extraHeaders value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraHeaders(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraHeaders.put(Objects.requireNonNull(k, "extraHeaders key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "extraHeaders value for key: " + k) : v);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putAllExtraHeaders(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraHeaders.put(Objects.requireNonNull(k, "extraHeaders key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "extraHeaders value for key: " + k) : v);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxInboundMessageSize(int maxInboundMessageSize) {
            Builder.checkNotIsSet(this.maxInboundMessageSizeIsSet(), "maxInboundMessageSize");
            this.maxInboundMessageSize = maxInboundMessageSize;
            this.optBits |= 8L;
            return this;
        }

        @Override
        public ImmutableClientConfig build() {
            this.checkRequiredAttributes();
            return new ImmutableClientConfig(this);
        }

        private boolean sslIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean userAgentIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean overrideAuthorityIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean maxInboundMessageSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean targetIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ClientConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.targetIsSet()) {
                attributes.add("target");
            }
            return "Cannot build ClientConfig, some of required attributes are not set " + attributes;
        }
    }
}

