/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.ExportRequest;
import io.deephaven.client.impl.ExportsRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExportsRequest", generator="Immutables")
@Immutable
final class ImmutableExportsRequest
extends ExportsRequest {
    private final List<ExportRequest> requests;

    private ImmutableExportsRequest(Builder builder) {
        this.requests = ImmutableExportsRequest.createUnmodifiableList(true, builder.requests);
    }

    @Override
    List<ExportRequest> requests() {
        return this.requests;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportsRequest && this.equalTo(0, (ImmutableExportsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportsRequest another) {
        return this.requests.equals(another.requests);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.requests.hashCode();
        return h;
    }

    public String toString() {
        return "ExportsRequest{requests=" + this.requests + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ExportsRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ExportsRequest.Builder {
        private final List<ExportRequest> requests = new ArrayList<ExportRequest>();

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addRequests(ExportRequest element) {
            this.requests.add(Objects.requireNonNull(element, "requests element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addRequests(ExportRequest ... elements) {
            for (ExportRequest element : elements) {
                this.requests.add(Objects.requireNonNull(element, "requests element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllRequests(Iterable<? extends ExportRequest> elements) {
            for (ExportRequest exportRequest : elements) {
                this.requests.add(Objects.requireNonNull(exportRequest, "requests element"));
            }
            return this;
        }

        @Override
        public ImmutableExportsRequest build() {
            return new ImmutableExportsRequest(this);
        }
    }
}

