/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.ClientChannelFactory;
import io.deephaven.client.impl.ClientConfig;
import io.deephaven.client.impl.SessionConfig;
import io.deephaven.client.impl.SessionFactoryConfig;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SessionFactoryConfig", generator="Immutables")
@Immutable
final class ImmutableSessionFactoryConfig
extends SessionFactoryConfig {
    private final ClientConfig clientConfig;
    private final ClientChannelFactory clientChannelFactory;
    private final SessionConfig sessionConfig;
    private final ScheduledExecutorService scheduler;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSessionFactoryConfig(Builder builder) {
        this.clientConfig = builder.clientConfig;
        this.scheduler = builder.scheduler;
        if (builder.clientChannelFactoryIsSet()) {
            this.initShim.clientChannelFactory(builder.clientChannelFactory);
        }
        if (builder.sessionConfigIsSet()) {
            this.initShim.sessionConfig(builder.sessionConfig);
        }
        this.clientChannelFactory = this.initShim.clientChannelFactory();
        this.sessionConfig = this.initShim.sessionConfig();
        this.initShim = null;
    }

    @Override
    public ClientConfig clientConfig() {
        return this.clientConfig;
    }

    @Override
    public ClientChannelFactory clientChannelFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clientChannelFactory() : this.clientChannelFactory;
    }

    @Override
    public SessionConfig sessionConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sessionConfig() : this.sessionConfig;
    }

    @Override
    public ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionFactoryConfig && this.equalTo(0, (ImmutableSessionFactoryConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableSessionFactoryConfig another) {
        return this.clientConfig.equals(another.clientConfig) && this.clientChannelFactory.equals(another.clientChannelFactory) && this.sessionConfig.equals(another.sessionConfig) && this.scheduler.equals(another.scheduler);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.clientConfig.hashCode();
        h += (h << 5) + this.clientChannelFactory.hashCode();
        h += (h << 5) + this.sessionConfig.hashCode();
        h += (h << 5) + this.scheduler.hashCode();
        return h;
    }

    public String toString() {
        return "SessionFactoryConfig{clientConfig=" + this.clientConfig + ", clientChannelFactory=" + this.clientChannelFactory + ", sessionConfig=" + this.sessionConfig + ", scheduler=" + this.scheduler + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SessionFactoryConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements SessionFactoryConfig.Builder {
        private static final long INIT_BIT_CLIENT_CONFIG = 1L;
        private static final long INIT_BIT_SCHEDULER = 2L;
        private static final long OPT_BIT_CLIENT_CHANNEL_FACTORY = 1L;
        private static final long OPT_BIT_SESSION_CONFIG = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private ClientConfig clientConfig;
        @Nullable
        private ClientChannelFactory clientChannelFactory;
        @Nullable
        private SessionConfig sessionConfig;
        @Nullable
        private ScheduledExecutorService scheduler;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientConfig(ClientConfig clientConfig) {
            Builder.checkNotIsSet(this.clientConfigIsSet(), "clientConfig");
            this.clientConfig = Objects.requireNonNull(clientConfig, "clientConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientChannelFactory(ClientChannelFactory clientChannelFactory) {
            Builder.checkNotIsSet(this.clientChannelFactoryIsSet(), "clientChannelFactory");
            this.clientChannelFactory = Objects.requireNonNull(clientChannelFactory, "clientChannelFactory");
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sessionConfig(SessionConfig sessionConfig) {
            Builder.checkNotIsSet(this.sessionConfigIsSet(), "sessionConfig");
            this.sessionConfig = Objects.requireNonNull(sessionConfig, "sessionConfig");
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scheduler(ScheduledExecutorService scheduler) {
            Builder.checkNotIsSet(this.schedulerIsSet(), "scheduler");
            this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableSessionFactoryConfig build() {
            this.checkRequiredAttributes();
            return new ImmutableSessionFactoryConfig(this);
        }

        private boolean clientChannelFactoryIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sessionConfigIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean clientConfigIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean schedulerIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SessionFactoryConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.clientConfigIsSet()) {
                attributes.add("clientConfig");
            }
            if (!this.schedulerIsSet()) {
                attributes.add("scheduler");
            }
            return "Cannot build SessionFactoryConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="SessionFactoryConfig", generator="Immutables")
    private final class InitShim {
        private byte clientChannelFactoryBuildStage = 0;
        private ClientChannelFactory clientChannelFactory;
        private byte sessionConfigBuildStage = 0;
        private SessionConfig sessionConfig;

        private InitShim() {
        }

        ClientChannelFactory clientChannelFactory() {
            if (this.clientChannelFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientChannelFactoryBuildStage == 0) {
                this.clientChannelFactoryBuildStage = (byte)-1;
                this.clientChannelFactory = Objects.requireNonNull(ImmutableSessionFactoryConfig.super.clientChannelFactory(), "clientChannelFactory");
                this.clientChannelFactoryBuildStage = 1;
            }
            return this.clientChannelFactory;
        }

        void clientChannelFactory(ClientChannelFactory clientChannelFactory) {
            this.clientChannelFactory = clientChannelFactory;
            this.clientChannelFactoryBuildStage = 1;
        }

        SessionConfig sessionConfig() {
            if (this.sessionConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sessionConfigBuildStage == 0) {
                this.sessionConfigBuildStage = (byte)-1;
                this.sessionConfig = Objects.requireNonNull(ImmutableSessionFactoryConfig.super.sessionConfig(), "sessionConfig");
                this.sessionConfigBuildStage = 1;
            }
            return this.sessionConfig;
        }

        void sessionConfig(SessionConfig sessionConfig) {
            this.sessionConfig = sessionConfig;
            this.sessionConfigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clientChannelFactoryBuildStage == -1) {
                attributes.add("clientChannelFactory");
            }
            if (this.sessionConfigBuildStage == -1) {
                attributes.add("sessionConfig");
            }
            return "Cannot build SessionFactoryConfig, attribute initializers form cycle " + attributes;
        }
    }
}

