/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.client.impl.SessionImplConfig;
import io.deephaven.proto.DeephavenChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SessionImplConfig", generator="Immutables")
@Immutable
final class ImmutableSessionImplConfig
extends SessionImplConfig {
    private final ScheduledExecutorService executor;
    private final DeephavenChannel channel;
    private final String authenticationTypeAndValue;
    private final boolean delegateToBatch;
    private final boolean mixinStacktrace;
    private final Duration executeTimeout;
    private final Duration closeTimeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSessionImplConfig(Builder builder) {
        this.executor = builder.executor;
        this.channel = builder.channel;
        if (builder.authenticationTypeAndValueIsSet()) {
            this.initShim.authenticationTypeAndValue(builder.authenticationTypeAndValue);
        }
        if (builder.delegateToBatchIsSet()) {
            this.initShim.delegateToBatch(builder.delegateToBatch);
        }
        if (builder.mixinStacktraceIsSet()) {
            this.initShim.mixinStacktrace(builder.mixinStacktrace);
        }
        if (builder.executeTimeoutIsSet()) {
            this.initShim.executeTimeout(builder.executeTimeout);
        }
        if (builder.closeTimeoutIsSet()) {
            this.initShim.closeTimeout(builder.closeTimeout);
        }
        this.authenticationTypeAndValue = this.initShim.authenticationTypeAndValue();
        this.delegateToBatch = this.initShim.delegateToBatch();
        this.mixinStacktrace = this.initShim.mixinStacktrace();
        this.executeTimeout = this.initShim.executeTimeout();
        this.closeTimeout = this.initShim.closeTimeout();
        this.initShim = null;
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public DeephavenChannel channel() {
        return this.channel;
    }

    @Override
    public String authenticationTypeAndValue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.authenticationTypeAndValue() : this.authenticationTypeAndValue;
    }

    @Override
    public boolean delegateToBatch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.delegateToBatch() : this.delegateToBatch;
    }

    @Override
    public boolean mixinStacktrace() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mixinStacktrace() : this.mixinStacktrace;
    }

    @Override
    public Duration executeTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executeTimeout() : this.executeTimeout;
    }

    @Override
    public Duration closeTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.closeTimeout() : this.closeTimeout;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionImplConfig && this.equalTo(0, (ImmutableSessionImplConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableSessionImplConfig another) {
        return this.executor.equals(another.executor) && this.channel.equals(another.channel) && this.authenticationTypeAndValue.equals(another.authenticationTypeAndValue) && this.delegateToBatch == another.delegateToBatch && this.mixinStacktrace == another.mixinStacktrace && this.executeTimeout.equals(another.executeTimeout) && this.closeTimeout.equals(another.closeTimeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.executor.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.authenticationTypeAndValue.hashCode();
        h += (h << 5) + Boolean.hashCode(this.delegateToBatch);
        h += (h << 5) + Boolean.hashCode(this.mixinStacktrace);
        h += (h << 5) + this.executeTimeout.hashCode();
        h += (h << 5) + this.closeTimeout.hashCode();
        return h;
    }

    public String toString() {
        return "SessionImplConfig{executor=" + this.executor + ", channel=" + this.channel + ", delegateToBatch=" + this.delegateToBatch + ", mixinStacktrace=" + this.mixinStacktrace + ", executeTimeout=" + this.executeTimeout + ", closeTimeout=" + this.closeTimeout + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SessionImplConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements SessionImplConfig.Builder {
        private static final long INIT_BIT_EXECUTOR = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private static final long OPT_BIT_AUTHENTICATION_TYPE_AND_VALUE = 1L;
        private static final long OPT_BIT_DELEGATE_TO_BATCH = 2L;
        private static final long OPT_BIT_MIXIN_STACKTRACE = 4L;
        private static final long OPT_BIT_EXECUTE_TIMEOUT = 8L;
        private static final long OPT_BIT_CLOSE_TIMEOUT = 16L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private ScheduledExecutorService executor;
        @Nullable
        private DeephavenChannel channel;
        @Nullable
        private String authenticationTypeAndValue;
        private boolean delegateToBatch;
        private boolean mixinStacktrace;
        @Nullable
        private Duration executeTimeout;
        @Nullable
        private Duration closeTimeout;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder executor(ScheduledExecutorService executor) {
            Builder.checkNotIsSet(this.executorIsSet(), "executor");
            this.executor = Objects.requireNonNull(executor, "executor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder channel(DeephavenChannel channel) {
            Builder.checkNotIsSet(this.channelIsSet(), "channel");
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authenticationTypeAndValue(String authenticationTypeAndValue) {
            Builder.checkNotIsSet(this.authenticationTypeAndValueIsSet(), "authenticationTypeAndValue");
            this.authenticationTypeAndValue = Objects.requireNonNull(authenticationTypeAndValue, "authenticationTypeAndValue");
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder delegateToBatch(boolean delegateToBatch) {
            Builder.checkNotIsSet(this.delegateToBatchIsSet(), "delegateToBatch");
            this.delegateToBatch = delegateToBatch;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder mixinStacktrace(boolean mixinStacktrace) {
            Builder.checkNotIsSet(this.mixinStacktraceIsSet(), "mixinStacktrace");
            this.mixinStacktrace = mixinStacktrace;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder executeTimeout(Duration executeTimeout) {
            Builder.checkNotIsSet(this.executeTimeoutIsSet(), "executeTimeout");
            this.executeTimeout = Objects.requireNonNull(executeTimeout, "executeTimeout");
            this.optBits |= 8L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder closeTimeout(Duration closeTimeout) {
            Builder.checkNotIsSet(this.closeTimeoutIsSet(), "closeTimeout");
            this.closeTimeout = Objects.requireNonNull(closeTimeout, "closeTimeout");
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        public ImmutableSessionImplConfig build() {
            this.checkRequiredAttributes();
            return new ImmutableSessionImplConfig(this);
        }

        private boolean authenticationTypeAndValueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean delegateToBatchIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean mixinStacktraceIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean executeTimeoutIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean closeTimeoutIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean executorIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SessionImplConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.executorIsSet()) {
                attributes.add("executor");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build SessionImplConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="SessionImplConfig", generator="Immutables")
    private final class InitShim {
        private byte authenticationTypeAndValueBuildStage = 0;
        private String authenticationTypeAndValue;
        private byte delegateToBatchBuildStage = 0;
        private boolean delegateToBatch;
        private byte mixinStacktraceBuildStage = 0;
        private boolean mixinStacktrace;
        private byte executeTimeoutBuildStage = 0;
        private Duration executeTimeout;
        private byte closeTimeoutBuildStage = 0;
        private Duration closeTimeout;

        private InitShim() {
        }

        String authenticationTypeAndValue() {
            if (this.authenticationTypeAndValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authenticationTypeAndValueBuildStage == 0) {
                this.authenticationTypeAndValueBuildStage = (byte)-1;
                this.authenticationTypeAndValue = Objects.requireNonNull(ImmutableSessionImplConfig.super.authenticationTypeAndValue(), "authenticationTypeAndValue");
                this.authenticationTypeAndValueBuildStage = 1;
            }
            return this.authenticationTypeAndValue;
        }

        void authenticationTypeAndValue(String authenticationTypeAndValue) {
            this.authenticationTypeAndValue = authenticationTypeAndValue;
            this.authenticationTypeAndValueBuildStage = 1;
        }

        boolean delegateToBatch() {
            if (this.delegateToBatchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.delegateToBatchBuildStage == 0) {
                this.delegateToBatchBuildStage = (byte)-1;
                this.delegateToBatch = ImmutableSessionImplConfig.super.delegateToBatch();
                this.delegateToBatchBuildStage = 1;
            }
            return this.delegateToBatch;
        }

        void delegateToBatch(boolean delegateToBatch) {
            this.delegateToBatch = delegateToBatch;
            this.delegateToBatchBuildStage = 1;
        }

        boolean mixinStacktrace() {
            if (this.mixinStacktraceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mixinStacktraceBuildStage == 0) {
                this.mixinStacktraceBuildStage = (byte)-1;
                this.mixinStacktrace = ImmutableSessionImplConfig.super.mixinStacktrace();
                this.mixinStacktraceBuildStage = 1;
            }
            return this.mixinStacktrace;
        }

        void mixinStacktrace(boolean mixinStacktrace) {
            this.mixinStacktrace = mixinStacktrace;
            this.mixinStacktraceBuildStage = 1;
        }

        Duration executeTimeout() {
            if (this.executeTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executeTimeoutBuildStage == 0) {
                this.executeTimeoutBuildStage = (byte)-1;
                this.executeTimeout = Objects.requireNonNull(ImmutableSessionImplConfig.super.executeTimeout(), "executeTimeout");
                this.executeTimeoutBuildStage = 1;
            }
            return this.executeTimeout;
        }

        void executeTimeout(Duration executeTimeout) {
            this.executeTimeout = executeTimeout;
            this.executeTimeoutBuildStage = 1;
        }

        Duration closeTimeout() {
            if (this.closeTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.closeTimeoutBuildStage == 0) {
                this.closeTimeoutBuildStage = (byte)-1;
                this.closeTimeout = Objects.requireNonNull(ImmutableSessionImplConfig.super.closeTimeout(), "closeTimeout");
                this.closeTimeoutBuildStage = 1;
            }
            return this.closeTimeout;
        }

        void closeTimeout(Duration closeTimeout) {
            this.closeTimeout = closeTimeout;
            this.closeTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.authenticationTypeAndValueBuildStage == -1) {
                attributes.add("authenticationTypeAndValue");
            }
            if (this.delegateToBatchBuildStage == -1) {
                attributes.add("delegateToBatch");
            }
            if (this.mixinStacktraceBuildStage == -1) {
                attributes.add("mixinStacktrace");
            }
            if (this.executeTimeoutBuildStage == -1) {
                attributes.add("executeTimeout");
            }
            if (this.closeTimeoutBuildStage == -1) {
                attributes.add("closeTimeout");
            }
            return "Cannot build SessionImplConfig, attribute initializers form cycle " + attributes;
        }
    }
}

