/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.client.impl.ClientChannelFactory;
import io.deephaven.client.impl.ClientConfig;
import io.deephaven.client.impl.ImmutableSessionFactoryConfig;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.SessionConfig;
import io.deephaven.client.impl.SessionFactory;
import io.deephaven.client.impl.SessionImpl;
import io.deephaven.client.impl.SessionImplConfig;
import io.grpc.ManagedChannel;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class SessionFactoryConfig {
    private static final SessionConfig SESSION_CONFIG_EMPTY = SessionConfig.builder().build();

    public static Builder builder() {
        return ImmutableSessionFactoryConfig.builder();
    }

    public abstract ClientConfig clientConfig();

    @Value.Default
    public ClientChannelFactory clientChannelFactory() {
        return ClientChannelFactory.defaultInstance();
    }

    @Value.Default
    public SessionConfig sessionConfig() {
        return SESSION_CONFIG_EMPTY;
    }

    public abstract ScheduledExecutorService scheduler();

    public final Factory factory() {
        return new Factory(this.clientChannelFactory().create(this.clientConfig()));
    }

    public static interface Builder {
        public Builder clientConfig(ClientConfig var1);

        public Builder clientChannelFactory(ClientChannelFactory var1);

        public Builder sessionConfig(SessionConfig var1);

        public Builder scheduler(ScheduledExecutorService var1);

        public SessionFactoryConfig build();
    }

    public final class Factory
    implements SessionFactory {
        private final ManagedChannel managedChannel;

        private Factory(ManagedChannel managedChannel) {
            this.managedChannel = Objects.requireNonNull(managedChannel);
        }

        @Override
        public Session newSession() {
            return this.newSession(SessionFactoryConfig.this.sessionConfig());
        }

        public Session newSession(SessionConfig sessionConfig) {
            try {
                return this.sessionImpl(sessionConfig);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        @Override
        public ManagedChannel managedChannel() {
            return this.managedChannel;
        }

        private SessionImpl sessionImpl(SessionConfig sessionConfig) throws InterruptedException {
            return SessionImpl.create(SessionImplConfig.from(sessionConfig, this.managedChannel, SessionFactoryConfig.this.scheduler()));
        }
    }
}

