/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.client.impl.ImmutableSessionImplConfig;
import io.deephaven.client.impl.SessionConfig;
import io.deephaven.client.impl.SessionConfigHelper;
import io.deephaven.client.impl.SessionImpl;
import io.deephaven.proto.DeephavenChannel;
import io.deephaven.proto.DeephavenChannelImpl;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class SessionImplConfig {
    public static final String DEEPHAVEN_SESSION_BATCH = "deephaven.session.batch";
    public static final String DEEPHAVEN_SESSION_BATCH_STACKTRACES = "deephaven.session.batch.stacktraces";
    public static final String DEEPHAVEN_SESSION_EXECUTE_TIMEOUT = "deephaven.session.executeTimeout";
    public static final String DEEPHAVEN_SESSION_CLOSE_TIMEOUT = "deephaven.session.closeTimeout";

    public static Builder builder() {
        return ImmutableSessionImplConfig.builder();
    }

    public static SessionImplConfig of(DeephavenChannel channel, ScheduledExecutorService scheduler, @Nullable @Named(value="authenticationTypeAndValue") String authenticationTypeAndValue) {
        Builder builder = SessionImplConfig.builder().executor(scheduler).channel(channel);
        if (authenticationTypeAndValue != null) {
            builder.authenticationTypeAndValue(authenticationTypeAndValue);
        }
        return builder.build();
    }

    public static SessionImplConfig from(SessionConfig sessionConfig, ManagedChannel managedChannel, ScheduledExecutorService defaultScheduler) {
        Builder builder = SessionImplConfig.builder().executor(sessionConfig.scheduler().orElse(defaultScheduler)).channel((DeephavenChannel)new DeephavenChannelImpl((Channel)managedChannel)).delegateToBatch(sessionConfig.delegateToBatch()).mixinStacktrace(sessionConfig.mixinStacktrace()).executeTimeout(sessionConfig.executeTimeout()).closeTimeout(sessionConfig.closeTimeout());
        sessionConfig.authenticationTypeAndValue().ifPresent(builder::authenticationTypeAndValue);
        return builder.build();
    }

    public abstract ScheduledExecutorService executor();

    public abstract DeephavenChannel channel();

    @Value.Default
    @Value.Redacted
    public String authenticationTypeAndValue() {
        return "Anonymous";
    }

    @Value.Default
    public boolean delegateToBatch() {
        return SessionConfigHelper.delegateToBatch();
    }

    @Value.Default
    public boolean mixinStacktrace() {
        return SessionConfigHelper.mixinStacktrace();
    }

    @Value.Default
    public Duration executeTimeout() {
        return SessionConfigHelper.executeTimeout();
    }

    @Value.Default
    public Duration closeTimeout() {
        return SessionConfigHelper.closeTimeout();
    }

    public final SessionImpl createSession() throws InterruptedException {
        return SessionImpl.create(this);
    }

    public static interface Builder {
        public Builder executor(ScheduledExecutorService var1);

        public Builder channel(DeephavenChannel var1);

        public Builder authenticationTypeAndValue(String var1);

        public Builder delegateToBatch(boolean var1);

        public Builder mixinStacktrace(boolean var1);

        public Builder executeTimeout(Duration var1);

        public Builder closeTimeout(Duration var1);

        public SessionImplConfig build();
    }
}

