/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.Export;
import io.deephaven.client.impl.ExportId;
import io.deephaven.client.impl.ExportRequest;
import io.deephaven.client.impl.HasExportId;
import io.deephaven.client.impl.PathId;
import io.deephaven.client.impl.TableServiceImpl;
import io.deephaven.client.impl.TicketId;
import io.deephaven.client.impl.TypedTicket;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.qst.table.TableSpec;
import io.deephaven.qst.table.TableSpecAdapter;
import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class TableHandle
extends TableSpecAdapter<TableHandle, TableHandle>
implements HasExportId,
Closeable {
    private final TableServiceImpl.Lifecycle lifecycle;
    private Export export;
    private final CountDownLatch doneLatch;
    private ExportedTableCreationResponse response;
    private Throwable error;

    TableHandle(TableSpec table, TableServiceImpl.Lifecycle lifecycle) {
        super(table);
        this.lifecycle = lifecycle;
        this.doneLatch = new CountDownLatch(1);
    }

    @Override
    public ExportId exportId() {
        return this.export.exportId();
    }

    @Override
    public TicketId ticketId() {
        return this.export.ticketId();
    }

    @Override
    public TypedTicket typedTicket() {
        return this.export.typedTicket();
    }

    @Override
    public PathId pathId() {
        return this.export.pathId();
    }

    public TableHandle newRef() {
        TableHandle handle = new TableHandle(this.table(), this.lifecycle);
        handle.init(this.export.newReference(handle.responseAdapter()));
        return handle;
    }

    public Export export() {
        return Objects.requireNonNull(this.export);
    }

    public void await() throws InterruptedException {
        this.doneLatch.await();
    }

    public void awaitUnchecked() {
        try {
            this.await();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    public boolean await(Duration timeout) throws InterruptedException {
        return this.doneLatch.await(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public boolean isDone() {
        return this.doneLatch.getCount() == 0L;
    }

    public boolean isSuccessful() {
        return this.response != null && this.response.getSuccess();
    }

    public ExportedTableCreationResponse response() {
        if (!this.isSuccessful()) {
            throw new IllegalStateException("Should only get the response on success");
        }
        return this.response;
    }

    public Optional<TableHandleException> error() {
        if (this.error != null) {
            return Optional.of(new TableHandleException(this.error));
        }
        if (this.response != null && !this.response.getSuccess()) {
            return Optional.of(new TableHandleException(this.response.getErrorInfo()));
        }
        return Optional.empty();
    }

    public void throwOnError() throws TableHandleException {
        Optional<TableHandleException> error = this.error();
        if (error.isPresent()) {
            throw error.get();
        }
    }

    public void throwOnErrorUnchecked() {
        Optional<TableHandleException> error = this.error();
        if (error.isPresent()) {
            throw error.get().asUnchecked();
        }
    }

    ExportRequest exportRequest() {
        return ExportRequest.of(this.table(), this.responseAdapter());
    }

    void init(Export export) {
        this.export = Objects.requireNonNull(export);
        if (this.lifecycle != null) {
            this.lifecycle.onInit(this);
        }
    }

    protected TableHandle adapt(TableSpec table) {
        return TableServiceImpl.executeUnchecked(this.export.exportStates(), table, this.lifecycle);
    }

    protected TableSpec adapt(TableHandle rhs) {
        if (this.export.exportStates() != rhs.export.exportStates()) {
            throw new IllegalArgumentException("Can't mix multiple exportStates() with TableHandle");
        }
        return rhs.export.table();
    }

    @Override
    public void close() {
        this.close(false);
    }

    void close(boolean skipNotify) {
        if (this.export.release() && !skipNotify && this.lifecycle != null) {
            this.lifecycle.onRelease(this);
        }
    }

    ResponseAdapter responseAdapter() {
        return new ResponseAdapter();
    }

    public final class UncheckedInterruptedException
    extends RuntimeException {
        private UncheckedInterruptedException(InterruptedException cause) {
            super(cause);
        }

        @Override
        public InterruptedException getCause() {
            return (InterruptedException)super.getCause();
        }

        public TableHandle handle() {
            return TableHandle.this;
        }
    }

    public final class UncheckedTableHandleException
    extends RuntimeException {
        private UncheckedTableHandleException(TableHandleException cause) {
            super(cause);
        }

        @Override
        public TableHandleException getCause() {
            return (TableHandleException)super.getCause();
        }

        public TableHandle handle() {
            return TableHandle.this;
        }
    }

    public final class TableHandleException
    extends Exception {
        public TableHandleException(String message) {
            super(message);
        }

        public TableHandleException(Throwable cause) {
            super(cause);
        }

        public UncheckedTableHandleException asUnchecked() {
            return new UncheckedTableHandleException(this);
        }

        public TableHandle handle() {
            return TableHandle.this;
        }

        public TableHandleException mixinStacktrace(StackTraceElement[] stackTrace) {
            TableHandleException decoratedException = new TableHandleException((Throwable)this);
            decoratedException.setStackTrace(stackTrace);
            return decoratedException;
        }
    }

    class ResponseAdapter
    implements ExportRequest.Listener {
        ResponseAdapter() {
        }

        @Override
        public void onNext(ExportedTableCreationResponse response) {
            TableHandle.this.response = response;
            TableHandle.this.doneLatch.countDown();
        }

        @Override
        public void onError(Throwable t) {
            TableHandle.this.error = t;
            TableHandle.this.doneLatch.countDown();
        }

        @Override
        public void onCompleted() {
            TableHandle.this.doneLatch.countDown();
        }
    }
}

