/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.api.TableOperations;
import io.deephaven.client.impl.ExportService;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.client.impl.TableHandleManagerBase;
import io.deephaven.client.impl.TableServiceImpl;
import io.deephaven.qst.LabeledValues;
import io.deephaven.qst.TableCreationLabeledLogic;
import io.deephaven.qst.TableCreationLogic;
import io.deephaven.qst.TableCreationLogic1Input;
import io.deephaven.qst.TableCreationLogic2Inputs;
import io.deephaven.qst.TableCreator;
import io.deephaven.qst.table.LabeledTables;
import io.deephaven.qst.table.StackTraceMixIn;
import io.deephaven.qst.table.StackTraceMixInCreator;
import io.deephaven.qst.table.TableSpec;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;

abstract class TableHandleManagerBatch
extends TableHandleManagerBase {
    private final boolean mixinStacktraces;

    TableHandleManagerBatch(boolean mixinStacktraces) {
        this.mixinStacktraces = mixinStacktraces;
    }

    protected abstract ExportService exportService();

    @Override
    protected TableHandle handle(TableSpec table) {
        return TableServiceImpl.executeUnchecked(this.exportService(), table, null);
    }

    @Override
    public TableHandle execute(TableSpec table) throws TableHandle.TableHandleException, InterruptedException {
        return TableServiceImpl.execute(this.exportService(), table, null);
    }

    @Override
    public List<TableHandle> execute(Iterable<TableSpec> tables) throws TableHandle.TableHandleException, InterruptedException {
        return TableServiceImpl.execute(this.exportService(), tables, null);
    }

    @Override
    public TableHandle executeLogic(TableCreationLogic logic) throws TableHandle.TableHandleException, InterruptedException {
        if (this.mixinStacktraces) {
            return (TableHandle)new MixinBasic(logic).run();
        }
        return this.execute(TableSpec.of((TableCreationLogic)logic));
    }

    @Override
    public List<TableHandle> executeLogic(Iterable<TableCreationLogic> logics) throws TableHandle.TableHandleException, InterruptedException {
        if (this.mixinStacktraces) {
            return (List)new MixinIterable(logics).run();
        }
        return this.execute(() -> StreamSupport.stream(logics.spliterator(), false).map(TableSpec::of).iterator());
    }

    @Override
    public LabeledValues<TableHandle> executeLogic(TableCreationLabeledLogic logic) throws TableHandle.TableHandleException, InterruptedException {
        if (this.mixinStacktraces) {
            return (LabeledValues)new MixinLabeled(logic).run();
        }
        return this.execute(LabeledTables.of((TableCreationLabeledLogic)logic));
    }

    @Override
    public TableHandle executeInputs(TableCreationLogic1Input logic, TableHandle t1) throws TableHandle.TableHandleException, InterruptedException {
        if (this.mixinStacktraces) {
            return (TableHandle)new Mixin1Handle(logic, t1).run();
        }
        TableSpec table1 = t1.table();
        TableSpec tableOut = (TableSpec)logic.create((TableOperations)table1);
        return this.execute(tableOut);
    }

    @Override
    public TableHandle executeInputs(TableCreationLogic2Inputs logic, TableHandle t1, TableHandle t2) throws TableHandle.TableHandleException, InterruptedException {
        if (this.mixinStacktraces) {
            return (TableHandle)new Mixin2Handles(logic, t1, t2).run();
        }
        TableSpec table1 = t1.table();
        TableSpec table2 = t2.table();
        TableSpec tableOut = (TableSpec)logic.create((TableOperations)table1, (TableOperations)table2);
        return this.execute(tableOut);
    }

    private class Mixin2Handles
    extends MixinBase<TableHandle> {
        private final TableCreationLogic2Inputs logic;
        private final TableHandle t1;
        private final TableHandle t2;

        public Mixin2Handles(TableCreationLogic2Inputs logic, TableHandle t1, TableHandle t2) {
            this.logic = Objects.requireNonNull(logic);
            this.t1 = Objects.requireNonNull(t1);
            this.t2 = Objects.requireNonNull(t2);
        }

        @Override
        TableHandle runImpl() throws InterruptedException, TableHandle.TableHandleException {
            StackTraceMixIn mixin1 = this.creator.adapt((TableOperations)this.t1.table());
            StackTraceMixIn mixin2 = this.creator.adapt((TableOperations)this.t2.table());
            StackTraceMixIn mixinOut = (StackTraceMixIn)this.logic.create((TableOperations)mixin1, (TableOperations)mixin2);
            return TableHandleManagerBatch.this.execute((TableSpec)mixinOut.ops());
        }
    }

    private class Mixin1Handle
    extends MixinBase<TableHandle> {
        private final TableCreationLogic1Input logic;
        private final TableHandle t1;

        public Mixin1Handle(TableCreationLogic1Input logic, TableHandle t1) {
            this.logic = Objects.requireNonNull(logic);
            this.t1 = Objects.requireNonNull(t1);
        }

        @Override
        TableHandle runImpl() throws InterruptedException, TableHandle.TableHandleException {
            StackTraceMixIn mixin1 = this.creator.adapt((TableOperations)this.t1.table());
            StackTraceMixIn mixinOut = (StackTraceMixIn)this.logic.create((TableOperations)mixin1);
            return TableHandleManagerBatch.this.execute((TableSpec)mixinOut.ops());
        }
    }

    private class MixinIterable
    extends MixinBase<List<TableHandle>> {
        private final Iterable<TableCreationLogic> logics;

        public MixinIterable(Iterable<TableCreationLogic> logics) {
            this.logics = Objects.requireNonNull(logics);
        }

        @Override
        protected List<TableHandle> runImpl() throws InterruptedException, TableHandle.TableHandleException {
            Iterable<TableSpec> tables = () -> StreamSupport.stream(this.logics.spliterator(), false).map(this::create).map(StackTraceMixIn::ops).iterator();
            return TableHandleManagerBatch.this.execute(tables);
        }

        private StackTraceMixIn<TableSpec, TableSpec> create(TableCreationLogic logic) {
            return (StackTraceMixIn)logic.create((TableCreator)this.creator);
        }
    }

    private class MixinLabeled
    extends MixinBase<LabeledValues<TableHandle>> {
        private final TableCreationLabeledLogic logic;

        public MixinLabeled(TableCreationLabeledLogic logic) {
            this.logic = Objects.requireNonNull(logic);
        }

        @Override
        protected LabeledValues<TableHandle> runImpl() throws InterruptedException, TableHandle.TableHandleException {
            LabeledValues mixins = this.logic.create((TableCreator)this.creator);
            LabeledTables labeledTables = LabeledTables.of((Iterable)mixins.labels(), () -> mixins.valuesStream().map(StackTraceMixIn::ops).iterator());
            return TableHandleManagerBatch.this.execute(labeledTables);
        }
    }

    private class MixinBasic
    extends MixinBase<TableHandle> {
        private final TableCreationLogic logic;

        public MixinBasic(TableCreationLogic logic) {
            this.logic = Objects.requireNonNull(logic);
        }

        @Override
        protected TableHandle runImpl() throws InterruptedException, TableHandle.TableHandleException {
            StackTraceMixIn mixin = (StackTraceMixIn)this.logic.create((TableCreator)this.creator);
            TableSpec table = (TableSpec)mixin.ops();
            return TableHandleManagerBatch.this.execute(table);
        }
    }

    private abstract class MixinBase<T> {
        final StackTraceMixInCreator<TableSpec, TableSpec> creator = StackTraceMixInCreator.of();

        private MixinBase() {
        }

        abstract T runImpl() throws InterruptedException, TableHandle.TableHandleException;

        T run() throws InterruptedException, TableHandle.TableHandleException {
            try {
                return this.runImpl();
            }
            catch (TableHandle.TableHandleException e) {
                throw this.mixinStacktrace(e);
            }
        }

        private TableHandle.TableHandleException mixinStacktrace(TableHandle.TableHandleException t) {
            TableSpec tableThatErrored = t.handle().table();
            return this.creator.elements((TableOperations)tableThatErrored).map(t::mixinStacktrace).orElse(t);
        }
    }
}

